/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp;

import java.util.HashMap;
import java.util.Map;
import org.objectstyle.cayenne.exp.ASTNode;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.exp.TraversalHelper;

class ASTCompiler {
    ASTCompiler() {
    }

    static ASTNode compile(Expression expression) throws ExpressionException {
        ExpressionParser handler = new ExpressionParser();
        expression.traverse(handler);
        return handler.finishParsing(expression);
    }

    static final class ExpressionParser
    extends TraversalHelper {
        ASTNode currentNode;
        ASTNode startNode;
        Map astMap = new HashMap();

        ExpressionParser() {
        }

        ASTNode finishParsing(Expression expression) {
            this.processNode((ASTNode)this.astMap.get(expression));
            return this.startNode;
        }

        public void startNode(Expression node, Expression parentNode) {
            ASTNode parentAST = (ASTNode)this.astMap.get(parentNode);
            this.astMap.put(node, ASTNode.buildExpressionNode(node, parentAST));
        }

        public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
            ASTNode newAST;
            int type = node.getType();
            if (type == 26 || type == 28 || childIndex == 1 && (type == 11 || type == 12 || type == 37 || type == 38)) {
                return;
            }
            Object child = node.getOperand(childIndex);
            if (child instanceof Expression) {
                newAST = (ASTNode)this.astMap.get(child);
            } else {
                ASTNode parentAST = (ASTNode)this.astMap.get(node);
                newAST = ASTNode.buildObjectNode(child, parentAST);
            }
            this.processNode(newAST);
        }

        void processNode(ASTNode newAST) {
            if (this.startNode == null) {
                this.startNode = newAST;
                this.currentNode = newAST;
            } else {
                this.currentNode.setNextNode(newAST);
                this.currentNode = newAST;
            }
        }
    }
}

