/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.gen;

import foundrylogic.vpp.VPPConfig;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.gen.ClassGenerationInfo;
import org.objectstyle.cayenne.gen.ClassGeneratorResourceLoader;
import org.objectstyle.cayenne.gen.EntityUtils;
import org.objectstyle.cayenne.gen.ImportUtils;
import org.objectstyle.cayenne.gen.StringUtils;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.ObjEntity;

public class ClassGenerator {
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    protected String versionString;
    protected Template classTemplate;
    protected Context velCtxt;
    protected ClassGenerationInfo classGenerationInfo;

    public static final synchronized void bootstrapVelocity(Class cl) {
    }

    public ClassGenerator(String template) throws Exception {
        this(template, VERSION_1_1);
    }

    public ClassGenerator(String template, String versionString) throws Exception {
        this.versionString = versionString;
        if (!VERSION_1_1.equals(versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + versionString);
        }
        this.velCtxt = new VelocityContext();
        this.classGenerationInfo = new ClassGenerationInfo();
        this.velCtxt.put("classGen", this.classGenerationInfo);
        this.initializeClassTemplate(template);
    }

    public ClassGenerator(String template, String versionString, VPPConfig vppConfig) throws Exception {
        this.versionString = versionString;
        if (!VERSION_1_2.equals(versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + versionString);
        }
        this.velCtxt = vppConfig != null ? vppConfig.getVelocityContext() : new VelocityContext();
        this.initializeClassTemplate(template);
    }

    private void initializeClassTemplate(String template) throws CayenneRuntimeException {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            Properties props = new Properties();
            props.put("runtime.log.logsystem.class", NullLogSystem.class.getName());
            props.put("resource.loader", "cayenne");
            props.put("cayenne.resource.loader.class", ClassGeneratorResourceLoader.class.getName());
            velocityEngine.init(props);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can't initialize Velocity", ex);
        }
        try {
            this.classTemplate = velocityEngine.getTemplate(template);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can't create template: " + template, ex);
        }
    }

    public void generateClass(Writer out, ObjEntity entity) throws Exception {
        if (!VERSION_1_1.equals(this.versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + this.versionString);
        }
        this.classGenerationInfo.setObjEntity(entity);
        this.classTemplate.merge(this.velCtxt, out);
    }

    public void generateClass(Writer out, DataMap dataMap, ObjEntity entity, String fqnBaseClass, String fqnSuperClass, String fqnSubClass) throws Exception {
        if (!VERSION_1_2.equals(this.versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity,String,String,String): " + this.versionString);
        }
        if (null == dataMap) {
            throw new IllegalStateException("DataMap MapClassGenerator constructor required for v1.2 templating.");
        }
        this.velCtxt.put("objEntity", entity);
        this.velCtxt.put("stringUtils", StringUtils.getInstance());
        this.velCtxt.put("entityUtils", new EntityUtils(dataMap, entity, fqnBaseClass, fqnSuperClass, fqnSubClass));
        this.velCtxt.put("importUtils", new ImportUtils());
        this.classTemplate.merge(this.velCtxt, out);
    }

    public ClassGenerationInfo getClassGenerationInfo() {
        return this.classGenerationInfo;
    }

    public String getPackageName() {
        return this.classGenerationInfo.getPackageName();
    }

    public void setPackageName(String packageName) {
        this.classGenerationInfo.setPackageName(packageName);
    }

    public void setSuperPackageName(String superPackageName) {
        this.classGenerationInfo.setSuperPackageName(superPackageName);
    }

    public String getClassName() {
        return this.classGenerationInfo.getClassName();
    }

    public void setClassName(String className) {
        this.classGenerationInfo.setClassName(className);
    }

    public void setSuperClassName(String value) {
        this.classGenerationInfo.setSuperClassName(value);
    }

    public void setSuperPrefix(String superPrefix) {
        this.classGenerationInfo.setSuperPrefix(superPrefix);
    }

    public String getSuperPackageName() {
        return this.classGenerationInfo.getSuperPackageName();
    }

    public String formatJavaType(String type) {
        return this.classGenerationInfo.formatJavaType(type);
    }

    public String formatVariableName(String variableName) {
        return this.classGenerationInfo.formatVariableName(variableName);
    }

    public String getSuperPrefix() {
        return this.classGenerationInfo.getSuperPrefix();
    }

    public void setProp(String prop) {
        this.classGenerationInfo.setProp(prop);
    }

    public String getProp() {
        return this.classGenerationInfo.getProp();
    }

    public String capitalized(String name) {
        return this.classGenerationInfo.capitalized(name);
    }

    public String capitalizedAsConstant(String name) {
        return this.classGenerationInfo.capitalizedAsConstant(name);
    }

    public String getCappedProp() {
        return this.classGenerationInfo.getCappedProp();
    }

    public String getPropAsConstantName() {
        return this.classGenerationInfo.getPropAsConstantName();
    }

    public boolean isContainingListProperties() {
        return this.classGenerationInfo.isContainingListProperties();
    }

    public boolean isUsingPackage() {
        return this.classGenerationInfo.isUsingPackage();
    }

    public boolean isUsingSuperPackage() {
        return this.classGenerationInfo.isUsingSuperPackage();
    }

    public ObjEntity getEntity() {
        return this.classGenerationInfo.getEntity();
    }

    public String getSuperClassName() {
        return this.classGenerationInfo.getSuperClassName();
    }
}

