/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;

public class CompoundDiff
implements GraphDiff {
    protected List diffs;

    public CompoundDiff() {
    }

    public CompoundDiff(List diffs) {
        this.diffs = diffs;
    }

    public boolean isNoop() {
        if (this.diffs == null || this.diffs.isEmpty()) {
            return true;
        }
        Iterator it = this.diffs.iterator();
        while (it.hasNext()) {
            if (((GraphDiff)it.next()).isNoop()) continue;
            return false;
        }
        return true;
    }

    public List getDiffs() {
        return this.diffs != null ? Collections.unmodifiableList(this.diffs) : Collections.EMPTY_LIST;
    }

    public void add(GraphDiff diff) {
        this.nonNullDiffs().add(diff);
    }

    public void addAll(Collection diffs) {
        this.nonNullDiffs().addAll(diffs);
    }

    public void apply(GraphChangeHandler tracker) {
        if (this.diffs == null) {
            return;
        }
        Iterator it = this.diffs.iterator();
        while (it.hasNext()) {
            GraphDiff change = (GraphDiff)it.next();
            change.apply(tracker);
        }
    }

    public void undo(GraphChangeHandler tracker) {
        if (this.diffs == null) {
            return;
        }
        ListIterator it = this.diffs.listIterator(this.diffs.size());
        while (it.hasPrevious()) {
            GraphDiff change = (GraphDiff)it.previous();
            change.undo(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List nonNullDiffs() {
        if (this.diffs == null) {
            CompoundDiff compoundDiff = this;
            synchronized (compoundDiff) {
                if (this.diffs == null) {
                    this.diffs = new ArrayList();
                }
            }
        }
        return this.diffs;
    }
}

