/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DerivedDbAttribute;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;

public class DerivedDbEntity
extends DbEntity {
    protected String parentEntityName;

    public DerivedDbEntity() {
    }

    public DerivedDbEntity(String name) {
        super(name);
    }

    public DerivedDbEntity(String name, DbEntity parentEntity) {
        super(name);
        this.setParentEntity(parentEntity);
        this.resetToParentView();
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-entity name=\"" + Util.encodeXmlAttribute(this.getName()));
        if (this.getSchema() != null && this.getSchema().trim().length() > 0) {
            encoder.print("\" schema=\"");
            encoder.print(Util.encodeXmlAttribute(this.getSchema().trim()));
        }
        if (this.getCatalog() != null && this.getCatalog().trim().length() > 0) {
            encoder.print("\" catalog=\"");
            encoder.print(Util.encodeXmlAttribute(this.getCatalog().trim()));
        }
        encoder.print("\" parentName=\"");
        encoder.print(Util.encodeXmlAttribute(this.getParentEntityName()));
        encoder.println("\">");
        encoder.indent(1);
        encoder.print(this.getAttributeMap());
        encoder.indent(-1);
        encoder.println("</db-entity>");
    }

    public void resetToParentView() {
        this.clearAttributes();
        this.clearRelationships();
        Iterator it = this.getParentEntity().getAttributes().iterator();
        while (it.hasNext()) {
            this.addAttribute(new DerivedDbAttribute(this, (DbAttribute)it.next()));
        }
        Iterator rit = this.getParentEntity().getRelationships().iterator();
        while (rit.hasNext()) {
            DbRelationship protoRel = (DbRelationship)rit.next();
            DbRelationship rel = new DbRelationship();
            rel.setName(protoRel.getName());
            rel.setSourceEntity(this);
            rel.setTargetEntity(protoRel.getTargetEntity());
            Iterator joins = protoRel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin protoJoin = (DbJoin)joins.next();
                DbJoin join = new DbJoin(rel);
                join.setSourceName(protoJoin.getSourceName());
                join.setTargetName(protoJoin.getTargetName());
                rel.addJoin(join);
            }
            this.addRelationship(rel);
        }
    }

    public DbEntity getParentEntity() {
        if (this.parentEntityName == null) {
            return null;
        }
        return this.getNonNullNamespace().getDbEntity(this.parentEntityName);
    }

    public void setParentEntity(DbEntity parentEntity) {
        this.setParentEntityName(parentEntity != null ? parentEntity.getName() : null);
    }

    public List getGroupByAttributes() {
        ArrayList<DerivedDbAttribute> list = new ArrayList<DerivedDbAttribute>();
        Iterator it = super.getAttributes().iterator();
        while (it.hasNext()) {
            DerivedDbAttribute attr = (DerivedDbAttribute)it.next();
            if (!attr.isGroupBy()) continue;
            list.add(attr);
        }
        return list;
    }

    public String getFullyQualifiedName() {
        return this.getParentEntity() != null ? this.getParentEntity().getFullyQualifiedName() : null;
    }

    public String getSchema() {
        return this.getParentEntity() != null ? this.getParentEntity().getSchema() : null;
    }

    public void setSchema(String schema) {
        throw new CayenneRuntimeException("Can't change schema of a derived entity.");
    }

    public String getCatalog() {
        return this.getParentEntity() != null ? this.getParentEntity().getCatalog() : null;
    }

    public void setCatalog(String catalog) {
        throw new CayenneRuntimeException("Can't change catalogue of a derived entity.");
    }

    public void removeAttribute(String attrName) {
        super.removeAttribute(attrName);
    }

    public String getParentEntityName() {
        return this.parentEntityName;
    }

    public void setParentEntityName(String parentEntityName) {
        this.parentEntityName = parentEntityName;
    }
}

