/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.collection.CompositeCollection;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityDescriptorFactory;
import org.objectstyle.cayenne.map.EntityInheritanceTree;
import org.objectstyle.cayenne.map.MappingNamespace;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.ClassDescriptorFactory;
import org.objectstyle.cayenne.query.Query;

public class EntityResolver
implements MappingNamespace,
Serializable {
    static final Object DUPLICATE_MARKER = new Object();
    protected boolean indexedByClass = true;
    protected Map queryCache;
    protected Map dbEntityCache;
    protected Map objEntityCache;
    protected Map procedureCache;
    protected List maps = new ArrayList();
    protected Map entityInheritanceCache;
    protected EntityResolver clientEntityResolver;
    protected transient ClassDescriptorFactory classDescriptorFactory;

    public EntityResolver() {
        this.queryCache = new HashMap();
        this.dbEntityCache = new HashMap();
        this.objEntityCache = new HashMap();
        this.procedureCache = new HashMap();
        this.entityInheritanceCache = new HashMap();
    }

    public EntityResolver(Collection dataMaps) {
        this();
        this.maps.addAll(dataMaps);
        this.constructCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getClientEntityResolver() {
        if (this.clientEntityResolver == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.clientEntityResolver == null) {
                    EntityResolver resolver = new EntityResolver();
                    Iterator it = this.getDataMaps().iterator();
                    while (it.hasNext()) {
                        DataMap map = (DataMap)it.next();
                        DataMap clientMap = map.getClientDataMap(this);
                        if (clientMap == null) continue;
                        resolver.addDataMap(clientMap);
                    }
                    this.clientEntityResolver = resolver;
                }
            }
        }
        return this.clientEntityResolver;
    }

    public Collection getDbEntities() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getDbEntities());
        }
        return c;
    }

    public Collection getObjEntities() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getObjEntities());
        }
        return c;
    }

    public Collection getProcedures() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getProcedures());
        }
        return c;
    }

    public Collection getQueries() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getQueries());
        }
        return c;
    }

    public DbEntity getDbEntity(String name) {
        return this._lookupDbEntity(name);
    }

    public ObjEntity getObjEntity(String name) {
        return this._lookupObjEntity(name);
    }

    public Procedure getProcedure(String name) {
        return this.lookupProcedure(name);
    }

    public Query getQuery(String name) {
        return this.lookupQuery(name);
    }

    public synchronized ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorFactory().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.maps.add(map);
            map.setNamespace(this);
            this.clearCache();
        }
    }

    public synchronized void clearCache() {
        this.queryCache.clear();
        this.dbEntityCache.clear();
        this.objEntityCache.clear();
        this.procedureCache.clear();
        this.entityInheritanceCache.clear();
        this.clientEntityResolver = null;
    }

    protected synchronized void constructCache() {
        this.clearCache();
        Iterator mapIterator = this.maps.iterator();
        while (mapIterator.hasNext()) {
            ObjEntity oe;
            DataMap map = (DataMap)mapIterator.next();
            Iterator objEntities = map.getObjEntities().iterator();
            while (objEntities.hasNext()) {
                Class entityClass;
                oe = (ObjEntity)objEntities.next();
                this.objEntityCache.put(oe.getName(), oe);
                if (!this.indexedByClass) continue;
                try {
                    entityClass = oe.getJavaClass();
                }
                catch (CayenneRuntimeException e) {
                    continue;
                }
                Object existing = this.objEntityCache.get(entityClass);
                if (existing != null) {
                    if (existing != DUPLICATE_MARKER) {
                        this.objEntityCache.put(entityClass, DUPLICATE_MARKER);
                    }
                } else {
                    this.objEntityCache.put(entityClass, oe);
                }
                if (oe.getDbEntity() == null) continue;
                Object existingDB = this.dbEntityCache.get(entityClass);
                if (existingDB != null) {
                    if (existingDB == DUPLICATE_MARKER) continue;
                    this.dbEntityCache.put(entityClass, DUPLICATE_MARKER);
                    continue;
                }
                this.dbEntityCache.put(entityClass, oe.getDbEntity());
            }
            objEntities = map.getObjEntities().iterator();
            while (objEntities.hasNext()) {
                String superOEName;
                oe = (ObjEntity)objEntities.next();
                EntityInheritanceTree node = (EntityInheritanceTree)this.entityInheritanceCache.get(oe.getName());
                if (node == null) {
                    node = new EntityInheritanceTree(oe);
                    this.entityInheritanceCache.put(oe.getName(), node);
                }
                if ((superOEName = oe.getSuperEntityName()) == null) continue;
                EntityInheritanceTree superNode = (EntityInheritanceTree)this.entityInheritanceCache.get(superOEName);
                if (superNode == null) {
                    ObjEntity superOE = (ObjEntity)this.objEntityCache.get(superOEName);
                    if (superOE == null) continue;
                    superNode = new EntityInheritanceTree(superOE);
                    this.entityInheritanceCache.put(superOEName, superNode);
                }
                superNode.addChildNode(node);
            }
            Iterator dbEntities = map.getDbEntities().iterator();
            while (dbEntities.hasNext()) {
                DbEntity de = (DbEntity)dbEntities.next();
                this.dbEntityCache.put(de.getName(), de);
            }
            Iterator procedures = map.getProcedures().iterator();
            while (procedures.hasNext()) {
                Procedure proc = (Procedure)procedures.next();
                this.procedureCache.put(proc.getName(), proc);
            }
            Iterator queries = map.getQueries().iterator();
            while (queries.hasNext()) {
                Query query = (Query)queries.next();
                String name = query.getName();
                Query existingQuery = this.queryCache.put(name, query);
                if (existingQuery == null || query == existingQuery) continue;
                throw new CayenneRuntimeException("More than one Query for name" + name);
            }
        }
    }

    public synchronized DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        Iterator it = this.maps.iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.clearCache();
    }

    public Collection getDataMaps() {
        return Collections.unmodifiableList(this.maps);
    }

    public synchronized DataMap lookupDataMap(Query q) {
        return q.getMetaData(this).getDataMap();
    }

    public synchronized DbEntity lookupDbEntity(Class aClass) {
        if (!this.indexedByClass) {
            throw new CayenneRuntimeException("Class index is disabled.");
        }
        return this._lookupDbEntity(aClass);
    }

    public synchronized DbEntity lookupDbEntity(Persistent dataObject) {
        return this._lookupDbEntity(dataObject.getClass());
    }

    public synchronized DbEntity lookupDbEntity(Query q) {
        return q.getMetaData(this).getDbEntity();
    }

    public EntityInheritanceTree lookupInheritanceTree(ObjEntity entity) {
        EntityInheritanceTree tree = (EntityInheritanceTree)this.entityInheritanceCache.get(entity.getName());
        if (tree == null) {
            this.constructCache();
            tree = (EntityInheritanceTree)this.entityInheritanceCache.get(entity.getName());
        }
        return tree == null || tree.getChildrenCount() == 0 ? null : tree;
    }

    public synchronized ObjEntity lookupObjEntity(Class aClass) {
        if (!this.indexedByClass) {
            throw new CayenneRuntimeException("Class index is disabled.");
        }
        return this._lookupObjEntity(aClass);
    }

    public synchronized ObjEntity lookupObjEntity(Persistent dataObject) {
        ObjectId id = dataObject.getObjectId();
        Object key = id != null ? id.getEntityName() : dataObject.getClass();
        return this._lookupObjEntity(key);
    }

    public synchronized ObjEntity lookupObjEntity(Query q) {
        return q.getMetaData(this).getObjEntity();
    }

    public synchronized ObjEntity lookupObjEntity(String entityName) {
        return this._lookupObjEntity(entityName);
    }

    public Procedure lookupProcedure(Query q) {
        return q.getMetaData(this).getProcedure();
    }

    public Procedure lookupProcedure(String procedureName) {
        Procedure result = (Procedure)this.procedureCache.get(procedureName);
        if (result == null) {
            this.constructCache();
            result = (Procedure)this.procedureCache.get(procedureName);
        }
        return result;
    }

    public synchronized Query lookupQuery(String name) {
        Query result = (Query)this.queryCache.get(name);
        if (result == null) {
            this.constructCache();
            result = (Query)this.queryCache.get(name);
        }
        return result;
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.clearCache();
        }
    }

    public boolean isIndexedByClass() {
        return this.indexedByClass;
    }

    public void setIndexedByClass(boolean b) {
        this.indexedByClass = b;
    }

    protected DbEntity _lookupDbEntity(Object object) {
        if (object instanceof DbEntity) {
            return (DbEntity)object;
        }
        Object result = this.dbEntityCache.get(object);
        if (result == null) {
            this.constructCache();
            result = this.dbEntityCache.get(object);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one DbEntity mapped to " + object);
        }
        return (DbEntity)result;
    }

    protected ObjEntity _lookupObjEntity(Object object) {
        Object result;
        if (object instanceof ObjEntity) {
            return (ObjEntity)((Object)object);
        }
        if (object instanceof DataObject) {
            object = object.getClass();
        }
        if ((result = this.objEntityCache.get(object)) == null) {
            this.constructCache();
            result = this.objEntityCache.get(object);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one ObjEntity mapped to " + object);
        }
        return (ObjEntity)result;
    }

    public ClassDescriptorFactory getClassDescriptorFactory() {
        if (this.classDescriptorFactory == null) {
            this.classDescriptorFactory = new EntityDescriptorFactory(this);
        }
        return this.classDescriptorFactory;
    }

    public void setClassDescriptorFactory(ClassDescriptorFactory descriptorFactory) {
        this.classDescriptorFactory = descriptorFactory;
    }
}

