/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import java.util.HashMap;
import org.objectstyle.cayenne.opp.hessian.EnumDeserializer;
import org.objectstyle.cayenne.opp.hessian.EnumSerializer;

class EnumSerializerFactory
extends AbstractSerializerFactory {
    private final EnumSerializer enumSerializer = new EnumSerializer();
    private HashMap<Class, Deserializer> cachedDeserializerMap;

    EnumSerializerFactory() {
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        return cl.isEnum() ? this.enumSerializer : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        if (cl.isEnum()) {
            Object deserializer = null;
            EnumSerializerFactory enumSerializerFactory = this;
            synchronized (enumSerializerFactory) {
                if (this.cachedDeserializerMap != null) {
                    deserializer = this.cachedDeserializerMap.get(cl);
                }
                if (deserializer == null) {
                    deserializer = new EnumDeserializer(cl);
                    if (this.cachedDeserializerMap == null) {
                        this.cachedDeserializerMap = new HashMap();
                    }
                    this.cachedDeserializerMap.put(cl, (Deserializer)deserializer);
                }
            }
            return deserializer;
        }
        return null;
    }
}

