/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.util.Collection;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.project.ApplicationProject;
import org.objectstyle.cayenne.project.ProjectException;

abstract class ApplicationUpgradeHandler {
    private static final ApplicationUpgradeHandler sharedInstance = new UpgradeHandler_1_1();

    ApplicationUpgradeHandler() {
    }

    static ApplicationUpgradeHandler sharedHandler() {
        return sharedInstance;
    }

    abstract String supportedVersion();

    abstract boolean checkForUpgrades(Configuration var1, Collection var2);

    abstract void performUpgrade(ApplicationProject var1) throws ProjectException;

    int compareVersion(String version) {
        double newVersion;
        double supported = ApplicationUpgradeHandler.decodeVersion(this.supportedVersion());
        return supported < (newVersion = ApplicationUpgradeHandler.decodeVersion(version)) ? -1 : (supported == newVersion ? 0 : 1);
    }

    static double decodeVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return 0.0;
        }
        StringBuffer buffer = new StringBuffer(version.length());
        boolean dotProcessed = false;
        for (int i = 0; i < version.length(); ++i) {
            char nextChar = version.charAt(i);
            if (nextChar == '.' && !dotProcessed) {
                dotProcessed = true;
                buffer.append('.');
                continue;
            }
            if (!Character.isDigit(nextChar)) continue;
            buffer.append(nextChar);
        }
        return Double.parseDouble(buffer.toString());
    }

    static class UpgradeHandler_1_1
    extends ApplicationUpgradeHandler {
        UpgradeHandler_1_1() {
        }

        String supportedVersion() {
            return "1.1";
        }

        void performUpgrade(ApplicationProject project) throws ProjectException {
            project.setModified(true);
            project.getConfiguration().setProjectVersion(this.supportedVersion());
            project.save();
        }

        boolean checkForUpgrades(Configuration project, Collection appendMessages) {
            String loadedVersion = project.getProjectVersion();
            int versionState = this.compareVersion(loadedVersion);
            if (versionState < 0) {
                String versionLabel = loadedVersion != null ? loadedVersion : "?";
                appendMessages.add("Newer Project Version Detected: \"" + versionLabel + "\"");
                return true;
            }
            if (versionState > 0) {
                String versionLabel = loadedVersion != null ? loadedVersion : "?";
                appendMessages.add("Older Project Version Detected: \"" + versionLabel + "\"");
                return true;
            }
            return false;
        }
    }
}

