/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.MappingNamesHelper;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class ObjEntityValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        ObjEntity ent = (ObjEntity)path.getObject();
        this.validateName(ent, path, validator);
        this.validateClassName(ent, path, validator);
        this.validateSuperClassName(ent, path, validator);
        if (ent.getDbEntity() == null) {
            validator.registerWarning("ObjEntity has no DbEntity mapping.", path);
        }
    }

    private void validateClassName(ObjEntity ent, ProjectPath path, Validator validator) {
        String className = ent.getClassName();
        if (Util.isEmptyString(className)) {
            return;
        }
        MappingNamesHelper helper = MappingNamesHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(className);
        if (invalidChars != null) {
            validator.registerWarning("ObjEntity Java class contains invalid characters: " + invalidChars, path);
        } else if (helper.invalidDataObjectClass(className)) {
            validator.registerWarning("ObjEntity Java class is invalid: " + className, path);
        } else if (className.indexOf(46) < 0) {
            validator.registerWarning("Placing Java class in default package is discouraged: " + className, path);
        }
    }

    private void validateSuperClassName(ObjEntity ent, ProjectPath path, Validator validator) {
        String superClassName = ent.getSuperClassName();
        if (Util.isEmptyString(superClassName)) {
            return;
        }
        MappingNamesHelper helper = MappingNamesHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(superClassName);
        if (invalidChars != null) {
            validator.registerWarning("ObjEntity Java superclass contains invalid characters: " + invalidChars, path);
        } else if (helper.invalidDataObjectClass(superClassName)) {
            validator.registerWarning("ObjEntity Java superclass is invalid: " + superClassName, path);
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
    }

    protected void validateName(ObjEntity ent, ProjectPath path, Validator validator) {
        String name = ent.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed ObjEntity.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        Iterator it = map.getObjEntities().iterator();
        while (it.hasNext()) {
            ObjEntity otherEnt = (ObjEntity)it.next();
            if (otherEnt == ent || !name.equals(otherEnt.getName())) continue;
            validator.registerError("Duplicate ObjEntity name: " + name + ".", path);
            break;
        }
    }
}

