/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class ProcedureValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        List parameters;
        Procedure procedure = (Procedure)treeNodePath.getObject();
        this.validateName(procedure, treeNodePath, validator);
        if (procedure.isReturningValue() && (parameters = procedure.getCallParameters()).size() == 0) {
            validator.registerWarning("Procedure returns a value, but has no parameters.", treeNodePath);
        }
    }

    protected void validateName(Procedure procedure, ProjectPath path, Validator validator) {
        String name = procedure.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed Procedure.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        Iterator it = map.getProcedures().iterator();
        while (it.hasNext()) {
            Procedure otherProcedure = (Procedure)it.next();
            if (otherProcedure == procedure || !name.equals(otherProcedure.getName())) continue;
            validator.registerError("Duplicate Procedure name: " + name + ".", path);
            break;
        }
    }
}

