/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.property;

import java.util.Collection;
import org.objectstyle.cayenne.Fault;
import org.objectstyle.cayenne.ValueHolder;
import org.objectstyle.cayenne.property.AbstractSingleObjectArcProperty;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.CollectionProperty;
import org.objectstyle.cayenne.property.PropertyAccessException;
import org.objectstyle.cayenne.property.PropertyAccessor;
import org.objectstyle.cayenne.property.PropertyVisitor;

public abstract class AbstractCollectionProperty
extends AbstractSingleObjectArcProperty
implements CollectionProperty {
    public AbstractCollectionProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, PropertyAccessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
    }

    public Object readProperty(Object object) throws PropertyAccessException {
        return this.ensureCollectionValueHolderSet(object);
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        ValueHolder holder = (ValueHolder)this.accessor.readPropertyDirectly(object);
        if (holder == null) {
            holder = this.createCollectionValueHolder(object);
            this.accessor.writePropertyDirectly(object, null, holder);
        }
        holder.setValueDirectly(newValue);
    }

    public void addTarget(Object source, Object target, boolean setReverse) {
        if (target == null) {
            throw new NullPointerException("Attempt to add null object.");
        }
        Collection collection = (Collection)this.readProperty(source);
        collection.add(target);
        if (target != null && setReverse) {
            this.setReverse(source, null, target);
        }
    }

    public void removeTarget(Object source, Object target, boolean setReverse) {
        Collection collection = (Collection)this.readProperty(source);
        collection.remove(target);
        if (target != null && setReverse) {
            this.setReverse(source, target, null);
        }
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitCollectionArc(this);
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
    }

    public void injectValueHolder(Object object) throws PropertyAccessException {
        this.ensureCollectionValueHolderSet(object);
    }

    protected ValueHolder ensureCollectionValueHolderSet(Object object) throws PropertyAccessException {
        Object value = this.accessor.readPropertyDirectly(object);
        if (value == null || value instanceof Fault) {
            value = this.createCollectionValueHolder(object);
            this.accessor.writePropertyDirectly(object, null, value);
        }
        return (ValueHolder)value;
    }

    protected abstract ValueHolder createCollectionValueHolder(Object var1) throws PropertyAccessException;
}

