/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.property;

import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.property.PropertyAccessException;
import org.objectstyle.cayenne.property.PropertyAccessor;

public class DataObjectAccessor
implements PropertyAccessor {
    protected String propertyName;

    public DataObjectAccessor(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
    }

    public String getName() {
        return this.propertyName;
    }

    public Object readPropertyDirectly(Object object) throws PropertyAccessException {
        try {
            DataObject dataObject = (DataObject)object;
            return dataObject.readPropertyDirectly(this.propertyName);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Object is not a DataObject: '" + object.getClass().getName() + "'", this, object, e);
        }
        catch (Throwable th) {
            throw new PropertyAccessException("Error reading DataObject property: " + this.propertyName, this, object, th);
        }
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        try {
            ((DataObject)object).writePropertyDirectly(this.propertyName, newValue);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Object is not a DataObject: '" + object.getClass().getName() + "'", this, object, e);
        }
        catch (Throwable th) {
            throw new PropertyAccessException("Error reading DataObject property: " + this.propertyName, this, object, th);
        }
    }
}

