/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.property;

import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.ValueHolder;
import org.objectstyle.cayenne.property.AbstractSingleObjectArcProperty;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.PropertyAccessException;
import org.objectstyle.cayenne.property.PropertyAccessor;
import org.objectstyle.cayenne.util.PersistentObjectHolder;

public class ValueHolderProperty
extends AbstractSingleObjectArcProperty {
    public ValueHolderProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, PropertyAccessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
    }

    public boolean isFault(Object object) {
        ValueHolder holder = (ValueHolder)this.accessor.readPropertyDirectly(object);
        return holder == null || holder.isFault();
    }

    public Object readPropertyDirectly(Object object) throws PropertyAccessException {
        ValueHolder holder = (ValueHolder)this.accessor.readPropertyDirectly(object);
        return holder != null ? holder.getValueDirectly() : null;
    }

    public Object readProperty(Object object) throws PropertyAccessException {
        return this.ensureValueHolderSet(object).getValue();
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        ValueHolder holder = (ValueHolder)this.accessor.readPropertyDirectly(object);
        if (holder == null) {
            holder = this.createValueHolder(object);
            this.accessor.writePropertyDirectly(object, null, holder);
        }
        holder.setValueDirectly(newValue);
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        this.ensureValueHolderSet(object).setValueDirectly(newValue);
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
    }

    public void injectValueHolder(Object object) throws PropertyAccessException {
        this.ensureValueHolderSet(object);
    }

    protected ValueHolder ensureValueHolderSet(Object object) throws PropertyAccessException {
        ValueHolder holder = (ValueHolder)this.accessor.readPropertyDirectly(object);
        if (holder == null) {
            holder = this.createValueHolder(object);
            this.accessor.writePropertyDirectly(object, null, holder);
        }
        return holder;
    }

    protected ValueHolder createValueHolder(Object object) throws PropertyAccessException {
        if (!(object instanceof Persistent)) {
            throw new PropertyAccessException("ValueHolders for non-persistent objects are not supported.", this, object);
        }
        return new PersistentObjectHolder((Persistent)object, this.getName());
    }
}

