/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.query.PrefetchTreeNode;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;
import org.objectstyle.cayenne.util.XMLSerializable;

class BaseQueryMetadata
implements QueryMetadata,
XMLSerializable,
Serializable {
    int fetchLimit = 0;
    int pageSize = 0;
    boolean fetchingDataRows = false;
    boolean refreshingObjects = true;
    boolean resolvingInherited = true;
    String cachePolicy = "nocache";
    PrefetchTreeNode prefetchTree;
    transient ObjEntity objEntity;
    transient DbEntity dbEntity;
    transient DataMap dataMap;
    transient Object lastRoot;
    transient EntityResolver lastEntityResolver;
    transient String cacheKey;

    BaseQueryMetadata() {
    }

    void copyFromInfo(QueryMetadata info) {
        this.lastEntityResolver = null;
        this.lastRoot = null;
        this.objEntity = null;
        this.dbEntity = null;
        this.dataMap = null;
        this.fetchingDataRows = info.isFetchingDataRows();
        this.fetchLimit = info.getFetchLimit();
        this.pageSize = info.getPageSize();
        this.refreshingObjects = info.isRefreshingObjects();
        this.resolvingInherited = info.isResolvingInherited();
        this.cachePolicy = info.getCachePolicy();
        this.cacheKey = info.getCacheKey();
        this.setPrefetchTree(info.getPrefetchTree());
    }

    boolean resolve(Object root, EntityResolver resolver, String cacheKey) {
        this.cacheKey = cacheKey;
        if (this.lastRoot != root || this.lastEntityResolver != resolver) {
            this.objEntity = null;
            this.dbEntity = null;
            this.dataMap = null;
            if (root != null) {
                if (root instanceof Class) {
                    this.objEntity = resolver.lookupObjEntity((Class)root);
                    if (this.objEntity != null) {
                        this.dbEntity = this.objEntity.getDbEntity();
                        this.dataMap = this.objEntity.getDataMap();
                    }
                } else if (root instanceof ObjEntity) {
                    this.objEntity = (ObjEntity)root;
                    this.dbEntity = this.objEntity.getDbEntity();
                    this.dataMap = this.objEntity.getDataMap();
                } else if (root instanceof String) {
                    this.objEntity = resolver.lookupObjEntity((String)root);
                    if (this.objEntity != null) {
                        this.dbEntity = this.objEntity.getDbEntity();
                        this.dataMap = this.objEntity.getDataMap();
                    }
                } else if (root instanceof DbEntity) {
                    this.dbEntity = (DbEntity)root;
                    this.dataMap = this.dbEntity.getDataMap();
                } else if (root instanceof DataMap) {
                    this.dataMap = (DataMap)root;
                } else if (root instanceof Persistent) {
                    this.objEntity = resolver.lookupObjEntity((Persistent)root);
                    if (this.objEntity != null) {
                        this.dbEntity = this.objEntity.getDbEntity();
                        this.dataMap = this.objEntity.getDataMap();
                    }
                }
            }
            this.lastRoot = root;
            this.lastEntityResolver = resolver;
            return true;
        }
        return false;
    }

    void initWithProperties(Map properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        Object fetchLimit = properties.get("cayenne.GenericSelectQuery.fetchLimit");
        Object pageSize = properties.get("cayenne.GenericSelectQuery.pageSize");
        Object refreshingObjects = properties.get("cayenne.GenericSelectQuery.refreshingObjects");
        Object fetchingDataRows = properties.get("cayenne.GenericSelectQuery.fetchingDataRows");
        Object resolvingInherited = properties.get("cayenne.GenericSelectQuery.resolvingInherited");
        Object cachePolicy = properties.get("cayenne.GenericSelectQuery.cachePolicy");
        this.fetchLimit = fetchLimit != null ? Integer.parseInt(fetchLimit.toString()) : 0;
        this.pageSize = pageSize != null ? Integer.parseInt(pageSize.toString()) : 0;
        this.refreshingObjects = refreshingObjects != null ? "true".equalsIgnoreCase(refreshingObjects.toString()) : true;
        this.fetchingDataRows = fetchingDataRows != null ? "true".equalsIgnoreCase(fetchingDataRows.toString()) : false;
        this.resolvingInherited = resolvingInherited != null ? "true".equalsIgnoreCase(resolvingInherited.toString()) : true;
        this.cachePolicy = cachePolicy != null ? cachePolicy.toString() : "nocache";
    }

    public void encodeAsXML(XMLEncoder encoder) {
        if (!this.refreshingObjects) {
            encoder.printProperty("cayenne.GenericSelectQuery.refreshingObjects", this.refreshingObjects);
        }
        if (this.fetchingDataRows) {
            encoder.printProperty("cayenne.GenericSelectQuery.fetchingDataRows", this.fetchingDataRows);
        }
        if (!this.resolvingInherited) {
            encoder.printProperty("cayenne.GenericSelectQuery.resolvingInherited", this.resolvingInherited);
        }
        if (this.fetchLimit != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.fetchLimit", this.fetchLimit);
        }
        if (this.pageSize != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.pageSize", this.pageSize);
        }
        if (this.cachePolicy != null && !"nocache".equals(this.cachePolicy)) {
            encoder.printProperty("cayenne.GenericSelectQuery.cachePolicy", this.cachePolicy);
        }
        if (this.prefetchTree != null) {
            this.prefetchTree.encodeAsXML(encoder);
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public Procedure getProcedure() {
        return null;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public ObjEntity getObjEntity() {
        return this.objEntity;
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.prefetchTree;
    }

    void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        if (prefetchTree != null) {
            try {
                prefetchTree = (PrefetchTreeNode)Util.cloneViaSerialization(prefetchTree);
            }
            catch (CayenneRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error cloning prefetch tree", e);
            }
        }
        this.prefetchTree = prefetchTree;
    }

    public String getCachePolicy() {
        return this.cachePolicy;
    }

    void setCachePolicy(String policy) {
        this.cachePolicy = policy;
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isRefreshingObjects() {
        return this.refreshingObjects;
    }

    public boolean isResolvingInherited() {
        return this.resolvingInherited;
    }

    void setFetchingDataRows(boolean b) {
        this.fetchingDataRows = b;
    }

    void setFetchLimit(int i) {
        this.fetchLimit = i;
    }

    void setPageSize(int i) {
        this.pageSize = i;
    }

    void setRefreshingObjects(boolean b) {
        this.refreshingObjects = b;
    }

    void setResolvingInherited(boolean b) {
        this.resolvingInherited = b;
    }

    PrefetchTreeNode addPrefetch(String path, int semantics) {
        if (this.prefetchTree == null) {
            this.prefetchTree = new PrefetchTreeNode();
        }
        PrefetchTreeNode node = this.prefetchTree.addPath(path);
        node.setSemantics(semantics);
        node.setPhantom(false);
        return node;
    }

    void addPrefetches(Collection prefetches, int semantics) {
        if (prefetches != null && !prefetches.isEmpty()) {
            Iterator it = prefetches.iterator();
            while (it.hasNext()) {
                String prefetch = (String)it.next();
                this.addPrefetch(prefetch, semantics);
            }
        }
    }

    void clearPrefetches() {
        this.prefetchTree = null;
    }

    void removePrefetch(String prefetch) {
        if (this.prefetchTree != null) {
            this.prefetchTree.removePath(prefetch);
        }
    }
}

