/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.DefaultQueryMetadata;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryRouter;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SQLActionVisitor;

public abstract class BatchQuery
implements Query {
    protected int batchIndex;
    protected DbEntity dbEntity;
    protected String name;

    public BatchQuery(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
        this.batchIndex = -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new DefaultQueryMetadata(){

            public DbEntity getDbEntity() {
                return BatchQuery.this.dbEntity;
            }
        };
    }

    public Object getRoot() {
        return this.dbEntity;
    }

    public void setRoot(Object root) {
        if (root != null && !(root instanceof DbEntity)) {
            throw new CayenneRuntimeException("Only DbEntity is supported as root: " + root);
        }
        this.dbEntity = (DbEntity)root;
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        router.route(router.engineForDataMap(this.dbEntity.getDataMap()), this, substitutedQuery);
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.batchAction(this);
    }

    public boolean isUsingOptimisticLocking() {
        return false;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public List getValuesForUpdateParameters(boolean includeNullValues) {
        int len = this.getDbAttributes().size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            Object value = this.getObject(i);
            if (!includeNullValues && value == null) continue;
            values.add(value);
        }
        return values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract List getDbAttributes();

    public void reset() {
        this.batchIndex = -1;
    }

    public boolean next() {
        ++this.batchIndex;
        return this.size() > this.batchIndex;
    }

    public Object getObject(int valueIndex) {
        return this.getValue(valueIndex);
    }

    public abstract Object getValue(int var1);

    public abstract int size();

    protected Object getValue(Map valueMap, DbAttribute attribute) {
        Object value = valueMap.get(attribute.getName());
        if (value instanceof Factory) {
            value = ((Factory)value).create();
            if (attribute.isPrimaryKey()) {
                if (value == null) {
                    String name = attribute.getEntity() != null ? attribute.getEntity().getName() : "<null>";
                    throw new CayenneRuntimeException("Failed to generate PK: " + name + "." + attribute.getName());
                }
                ObjectId id = this.getObjectId();
                if (id != null) {
                    id.getReplacementIdMap().put(attribute.getName(), value);
                }
            }
            valueMap.put(attribute.getName(), value);
        }
        return value;
    }

    public ObjectId getObjectId() {
        return null;
    }
}

