/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.query.AbstractQuery;
import org.objectstyle.cayenne.query.BaseQueryMetadata;
import org.objectstyle.cayenne.query.GenericSelectQuery;
import org.objectstyle.cayenne.query.ParameterizedQuery;
import org.objectstyle.cayenne.query.PrefetchTreeNode;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SQLActionVisitor;
import org.objectstyle.cayenne.util.XMLEncoder;
import org.objectstyle.cayenne.util.XMLSerializable;

public class SQLTemplate
extends AbstractQuery
implements GenericSelectQuery,
ParameterizedQuery,
XMLSerializable {
    private static final Transformer nullMapTransformer = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input : Collections.EMPTY_MAP;
        }
    };
    protected String defaultTemplate;
    protected Map templates;
    protected Map[] parameters;
    BaseQueryMetadata selectInfo = new BaseQueryMetadata();
    protected boolean selecting;

    public SQLTemplate() {
    }

    public SQLTemplate(DataMap rootMap, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootMap);
    }

    public SQLTemplate(ObjEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(Class rootClass, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootClass);
    }

    public SQLTemplate(DbEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(String objEntityName, String defaultTemplate) {
        this.setRoot(objEntityName);
        this.setDefaultTemplate(defaultTemplate);
    }

    public SQLTemplate(boolean selecting) {
        this();
        this.setSelecting(selecting);
    }

    public SQLTemplate(DataMap rootMap, String defaultTemplate, boolean selecting) {
        this(rootMap, defaultTemplate);
        this.setSelecting(selecting);
    }

    public SQLTemplate(ObjEntity rootEntity, String defaultTemplate, boolean selecting) {
        this(rootEntity, defaultTemplate);
        this.setSelecting(selecting);
    }

    public SQLTemplate(Class rootClass, String defaultTemplate, boolean selecting) {
        this(rootClass, defaultTemplate);
        this.setSelecting(selecting);
    }

    public SQLTemplate(DbEntity rootEntity, String defaultTemplate, boolean selecting) {
        this(rootEntity, defaultTemplate);
        this.setSelecting(selecting);
    }

    public SQLTemplate(String objEntityName, String defaultTemplate, boolean selecting) {
        this(objEntityName, defaultTemplate);
        this.setSelecting(selecting);
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.selectInfo.resolve(this.root, resolver, this.getName());
        return this.selectInfo;
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.sqlAction(this);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.objectstyle.cayenne.map.SQLTemplateBuilder");
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        } else if (this.root instanceof DataMap) {
            rootType = "data-map";
            rootString = ((DataMap)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.selectInfo.encodeAsXML(encoder);
        if (this.defaultTemplate != null) {
            encoder.print("<sql><![CDATA[");
            encoder.print(this.defaultTemplate);
            encoder.println("]]></sql>");
        }
        if (this.templates != null && !this.templates.isEmpty()) {
            Iterator it = this.templates.entrySet().iterator();
            while (it.hasNext()) {
                String sql;
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null || (sql = value.toString().trim()).length() <= 0) continue;
                encoder.print("<sql adapter-class=\"");
                encoder.print(key.toString());
                encoder.print("\"><![CDATA[");
                encoder.print(sql);
                encoder.println("]]></sql>");
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public void initWithProperties(Map properties) {
        this.selectInfo.initWithProperties(properties);
    }

    public Iterator parametersIterator() {
        return this.parameters == null || this.parameters.length == 0 ? IteratorUtils.emptyIterator() : IteratorUtils.transformedIterator(IteratorUtils.arrayIterator(this.parameters), nullMapTransformer);
    }

    public int parametersSize() {
        return this.parameters != null ? this.parameters.length : 0;
    }

    public SQLTemplate queryWithParameters(Map parameters) {
        return this.queryWithParameters(new Map[]{parameters});
    }

    public SQLTemplate queryWithParameters(Map[] parameters) {
        SQLTemplate query = new SQLTemplate();
        query.setRoot(this.root);
        query.setDefaultTemplate(this.getDefaultTemplate());
        if (this.templates != null) {
            query.templates = new HashMap(this.templates);
        }
        query.selectInfo.copyFromInfo(this.selectInfo);
        query.setParameters(parameters);
        return query;
    }

    public Query createQuery(Map parameters) {
        return this.queryWithParameters(parameters);
    }

    public String getCachePolicy() {
        return this.selectInfo.getCachePolicy();
    }

    public void setCachePolicy(String policy) {
        this.selectInfo.setCachePolicy(policy);
    }

    public int getFetchLimit() {
        return this.selectInfo.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.selectInfo.setFetchLimit(fetchLimit);
    }

    public int getPageSize() {
        return this.selectInfo.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.selectInfo.setPageSize(pageSize);
    }

    public void setFetchingDataRows(boolean flag) {
        this.selectInfo.setFetchingDataRows(flag);
    }

    public boolean isFetchingDataRows() {
        return this.selectInfo.isFetchingDataRows();
    }

    public boolean isRefreshingObjects() {
        return this.selectInfo.isRefreshingObjects();
    }

    public void setRefreshingObjects(boolean flag) {
        this.selectInfo.setRefreshingObjects(flag);
    }

    public boolean isResolvingInherited() {
        return this.selectInfo.isResolvingInherited();
    }

    public void setResolvingInherited(boolean b) {
        this.selectInfo.setResolvingInherited(b);
    }

    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(String string) {
        this.defaultTemplate = string;
    }

    public synchronized String getTemplate(String key) {
        if (this.templates == null) {
            return this.defaultTemplate;
        }
        String template = (String)this.templates.get(key);
        return template != null ? template : this.defaultTemplate;
    }

    public synchronized String getCustomTemplate(String key) {
        return this.templates != null ? (String)this.templates.get(key) : null;
    }

    public synchronized void setTemplate(String key, String template) {
        if (this.templates == null) {
            this.templates = new HashMap();
        }
        this.templates.put(key, template);
    }

    public synchronized void removeTemplate(String key) {
        if (this.templates != null) {
            this.templates.remove(key);
        }
    }

    public synchronized Collection getTemplateKeys() {
        return this.templates != null ? Collections.unmodifiableCollection(this.templates.keySet()) : Collections.EMPTY_LIST;
    }

    public Map getParameters() {
        Map map = this.parameters != null && this.parameters.length > 0 ? this.parameters[0] : null;
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public void setParameters(Map map) {
        Map[] mapArray;
        if (map != null) {
            Map[] mapArray2 = new Map[1];
            mapArray = mapArray2;
            mapArray2[0] = map;
        } else {
            mapArray = null;
        }
        this.setParameters(mapArray);
    }

    public void setParameters(Map[] parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new Map[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameters[i] = parameters[i] != null ? new HashMap(parameters[i]) : new HashMap();
            }
        }
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public void setSelecting(boolean b) {
        this.selecting = b;
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.selectInfo.getPrefetchTree();
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.selectInfo.addPrefetch(prefetchPath, 1);
    }

    public void removePrefetch(String prefetch) {
        this.selectInfo.removePrefetch(prefetch);
    }

    public void addPrefetches(Collection prefetches) {
        this.selectInfo.addPrefetches(prefetches, 1);
    }

    public void clearPrefetches() {
        this.selectInfo.clearPrefetches();
    }
}

