/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.query.BaseQueryMetadata;
import org.objectstyle.cayenne.query.GenericSelectQuery;
import org.objectstyle.cayenne.query.Ordering;
import org.objectstyle.cayenne.query.ParameterizedQuery;
import org.objectstyle.cayenne.query.PrefetchTreeNode;
import org.objectstyle.cayenne.query.QualifiedQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryMetadataWrapper;
import org.objectstyle.cayenne.query.QueryRouter;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SQLActionVisitor;
import org.objectstyle.cayenne.query.SelectQueryPrefetchRouterAction;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;
import org.objectstyle.cayenne.util.XMLSerializable;

public class SelectQuery
extends QualifiedQuery
implements GenericSelectQuery,
ParameterizedQuery,
XMLSerializable {
    public static final String DISTINCT_PROPERTY = "cayenne.SelectQuery.distinct";
    public static final boolean DISTINCT_DEFAULT = false;
    protected List customDbAttributes;
    protected List orderings;
    protected boolean distinct;
    protected Expression parentQualifier;
    protected String parentObjEntityName;
    BaseQueryMetadata selectInfo = new BaseQueryMetadata();

    public SelectQuery() {
    }

    public SelectQuery(ObjEntity root) {
        this(root, null);
    }

    public SelectQuery(ObjEntity root, Expression qualifier) {
        this();
        this.init(root, qualifier);
    }

    public SelectQuery(Class rootClass) {
        this(rootClass, null);
    }

    public SelectQuery(Class rootClass, Expression qualifier) {
        this.init(rootClass, qualifier);
    }

    public SelectQuery(DbEntity root) {
        this(root, null);
    }

    public SelectQuery(DbEntity root, Expression qualifier) {
        this();
        this.init(root, qualifier);
    }

    public SelectQuery(String objEntityName) {
        this(objEntityName, null);
    }

    public SelectQuery(String objEntityName, Expression qualifier) {
        this.init(objEntityName, qualifier);
    }

    private void init(Object root, Expression qualifier) {
        this.setRoot(root);
        this.setQualifier(qualifier);
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.selectInfo.resolve(this.root, resolver, this.getName());
        if (this.isFetchingCustomAttributes()) {
            QueryMetadataWrapper wrapper = new QueryMetadataWrapper(this.selectInfo);
            wrapper.override("cayenne.GenericSelectQuery.fetchingDataRows", Boolean.TRUE);
            return wrapper;
        }
        return this.selectInfo;
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        super.route(router, resolver, substitutedQuery);
        this.routePrefetches(router, resolver);
    }

    void routePrefetches(QueryRouter router, EntityResolver resolver) {
        new SelectQueryPrefetchRouterAction().route(this, router, resolver);
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.objectSelectAction(this);
    }

    public void initWithProperties(Map properties) {
        Object distinct;
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        this.distinct = (distinct = properties.get(DISTINCT_PROPERTY)) != null ? "true".equalsIgnoreCase(distinct.toString()) : false;
        this.selectInfo.initWithProperties(properties);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.objectstyle.cayenne.map.SelectQueryBuilder");
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        if (this.distinct) {
            encoder.printProperty(DISTINCT_PROPERTY, this.distinct);
        }
        this.selectInfo.encodeAsXML(encoder);
        if (this.qualifier != null) {
            encoder.print("<qualifier>");
            this.qualifier.encodeAsXML(encoder);
            encoder.println("</qualifier>");
        }
        if (this.orderings != null && !this.orderings.isEmpty()) {
            Iterator it = this.orderings.iterator();
            while (it.hasNext()) {
                Ordering ordering = (Ordering)it.next();
                ordering.encodeAsXML(encoder);
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public SelectQuery queryWithParameters(Map parameters) {
        return this.queryWithParameters(parameters, true);
    }

    public SelectQuery queryWithParameters(Map parameters, boolean pruneMissing) {
        SelectQuery query = new SelectQuery();
        query.setDistinct(this.distinct);
        query.selectInfo.copyFromInfo(this.selectInfo);
        query.setParentObjEntityName(this.parentObjEntityName);
        query.setParentQualifier(this.parentQualifier);
        query.setRoot(this.root);
        if (!Util.isEmptyString(this.name)) {
            StringBuffer buffer = new StringBuffer(this.name);
            if (parameters != null && !parameters.isEmpty()) {
                buffer.append(((Object)parameters).hashCode());
            }
            query.setName(buffer.toString());
        }
        if (this.orderings != null) {
            query.addOrderings(this.orderings);
        }
        if (this.customDbAttributes != null) {
            query.addCustomDbAttributes(this.customDbAttributes);
        }
        if (this.qualifier != null) {
            query.setQualifier(this.qualifier.expWithParameters(parameters, pruneMissing));
        }
        return query;
    }

    public Query createQuery(Map parameters) {
        return this.queryWithParameters(parameters);
    }

    public void addOrdering(Ordering ordering) {
        this.nonNullOrderings().add(ordering);
    }

    public void addOrderings(List orderings) {
        this.nonNullOrderings().addAll(orderings);
    }

    public void addOrdering(String sortPathSpec, boolean isAscending) {
        this.addOrdering(new Ordering(sortPathSpec, isAscending));
    }

    public void addOrdering(String sortPathSpec, boolean isAscending, boolean ignoreCase) {
        this.addOrdering(new Ordering(sortPathSpec, isAscending, ignoreCase));
    }

    public void removeOrdering(Ordering ordering) {
        if (this.orderings != null) {
            this.orderings.remove(ordering);
        }
    }

    public List getOrderings() {
        return this.orderings != null ? this.orderings : Collections.EMPTY_LIST;
    }

    public void clearOrderings() {
        this.orderings = null;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List getCustomDbAttributes() {
        if ((this.customDbAttributes == null || this.customDbAttributes.isEmpty()) && this.root instanceof DbEntity) {
            Collection attributes = ((DbEntity)this.root).getAttributes();
            ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                DbAttribute attribute = (DbAttribute)it.next();
                attributeNames.add(attribute.getName());
            }
            return attributeNames;
        }
        return this.customDbAttributes != null ? this.customDbAttributes : Collections.EMPTY_LIST;
    }

    public void addCustomDbAttribute(String attributePath) {
        this.nonNullCustomDbAttributes().add(attributePath);
    }

    public void addCustomDbAttributes(List attrPaths) {
        this.nonNullCustomDbAttributes().addAll(attrPaths);
    }

    public boolean isFetchingCustomAttributes() {
        return this.root instanceof DbEntity || this.customDbAttributes != null && !this.customDbAttributes.isEmpty();
    }

    public Collection getPrefetches() {
        if (this.getPrefetchTree() != null) {
            Collection nodes = this.getPrefetchTree().nonPhantomNodes();
            ArrayList<String> paths = new ArrayList<String>(nodes.size());
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                paths.add(((PrefetchTreeNode)it.next()).getPath());
            }
            return paths;
        }
        return Collections.EMPTY_LIST;
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.selectInfo.getPrefetchTree();
    }

    public void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.selectInfo.setPrefetchTree(prefetchTree);
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.selectInfo.addPrefetch(prefetchPath, 0);
    }

    public void addPrefetches(Collection prefetches) {
        this.selectInfo.addPrefetches(prefetches, 0);
    }

    public void clearPrefetches() {
        this.selectInfo.clearPrefetches();
    }

    public void removePrefetch(String prefetchPath) {
        this.selectInfo.removePrefetch(prefetchPath);
    }

    public boolean isFetchingDataRows() {
        return this.isFetchingCustomAttributes() || this.selectInfo.isFetchingDataRows();
    }

    public void setFetchingDataRows(boolean flag) {
        this.selectInfo.setFetchingDataRows(flag);
    }

    public boolean isRefreshingObjects() {
        return this.selectInfo.isRefreshingObjects();
    }

    public void setRefreshingObjects(boolean flag) {
        this.selectInfo.setRefreshingObjects(flag);
    }

    public String getCachePolicy() {
        return this.selectInfo.getCachePolicy();
    }

    public void setCachePolicy(String policy) {
        this.selectInfo.setCachePolicy(policy);
    }

    public int getFetchLimit() {
        return this.selectInfo.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.selectInfo.setFetchLimit(fetchLimit);
    }

    public void setParentQualifier(Expression parentQualifier) {
        this.parentQualifier = parentQualifier;
    }

    public Expression getParentQualifier() {
        return this.parentQualifier;
    }

    public void andParentQualifier(Expression e) {
        this.parentQualifier = this.parentQualifier != null ? this.parentQualifier.andExp(e) : e;
    }

    public void orParentQualifier(Expression e) {
        this.parentQualifier = this.parentQualifier != null ? this.parentQualifier.orExp(e) : e;
    }

    public String getParentObjEntityName() {
        return this.parentObjEntityName;
    }

    public void setParentObjEntityName(String parentObjEntityName) {
        this.parentObjEntityName = parentObjEntityName;
    }

    public boolean isQualifiedOnParent() {
        return this.getParentObjEntityName() != null && this.parentQualifier != null;
    }

    public int getPageSize() {
        return this.selectInfo.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.selectInfo.setPageSize(pageSize);
    }

    public boolean isResolvingInherited() {
        return this.selectInfo.isResolvingInherited();
    }

    public void setResolvingInherited(boolean b) {
        this.selectInfo.setResolvingInherited(b);
    }

    List nonNullCustomDbAttributes() {
        if (this.customDbAttributes == null) {
            this.customDbAttributes = new ArrayList();
        }
        return this.customDbAttributes;
    }

    List nonNullOrderings() {
        if (this.orderings == null) {
            this.orderings = new ArrayList();
        }
        return this.orderings;
    }
}

