/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.tools;

import foundrylogic.vpp.VPPConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.objectstyle.cayenne.gen.AntClassGenerator;
import org.objectstyle.cayenne.gen.DefaultClassGenerator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.MapLoader;
import org.objectstyle.cayenne.tools.CayenneTask;
import org.objectstyle.cayenne.tools.NamePatternMatcher;
import org.objectstyle.cayenne.util.Util;
import org.xml.sax.InputSource;

public class CayenneGenerator
extends CayenneTask {
    protected String includeEntitiesPattern;
    protected String excludeEntitiesPattern;
    protected VPPConfig vppConfig;
    protected File map;
    protected File[] additionalMaps;
    protected DefaultClassGenerator generator = this.createGenerator();

    protected DefaultClassGenerator createGenerator() {
        AntClassGenerator gen = new AntClassGenerator();
        gen.setParentTask(this);
        return gen;
    }

    public void execute() throws BuildException {
        this.configureLogging();
        this.validateAttributes();
        try {
            this.processMap();
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            String thMessage = th.getLocalizedMessage();
            String message = "Error generating classes: ";
            message = message + (!Util.isEmptyString(thMessage) ? thMessage : th.getClass().getName());
            super.log(message);
            throw new BuildException(message, th);
        }
    }

    protected void processMap() throws Exception {
        DataMap dataMap = this.loadDataMap();
        DataMap[] additionalDataMaps = this.loadAdditionalDataMaps();
        EntityResolver entityResolver = new EntityResolver(Collections.singleton(dataMap));
        dataMap.setNamespace(entityResolver);
        for (int i = 0; i < additionalDataMaps.length; ++i) {
            entityResolver.addDataMap(additionalDataMaps[i]);
            additionalDataMaps[i].setNamespace(entityResolver);
        }
        ArrayList entityList = new ArrayList(dataMap.getObjEntities());
        NamePatternMatcher namePatternMatcher = new NamePatternMatcher(this, this.includeEntitiesPattern, this.excludeEntitiesPattern);
        namePatternMatcher.filter(entityList);
        if (!"1.1".equals(this.generator.getVersionString())) {
            this.initializeVppConfig();
            this.generator.setVppConfig(this.vppConfig);
        }
        this.generator.setTimestamp(this.map.lastModified());
        this.generator.setDataMap(dataMap);
        this.generator.setObjEntities(entityList);
        this.generator.validateAttributes();
        this.generator.execute();
    }

    protected DataMap loadDataMap(File mapName) throws Exception {
        InputSource in = new InputSource(mapName.getCanonicalPath());
        return new MapLoader().loadDataMap(in);
    }

    protected DataMap loadDataMap() throws Exception {
        return this.loadDataMap(this.map);
    }

    protected DataMap[] loadAdditionalDataMaps() throws Exception {
        if (null == this.additionalMaps) {
            return new DataMap[0];
        }
        DataMap[] dataMaps = new DataMap[this.additionalMaps.length];
        for (int i = 0; i < this.additionalMaps.length; ++i) {
            dataMaps[i] = this.loadDataMap(this.additionalMaps[i]);
        }
        return dataMaps;
    }

    protected void validateAttributes() throws BuildException {
        if (this.map == null && this.getProject() == null) {
            throw new BuildException("either 'map' or 'project' is required.");
        }
    }

    public void setMap(File map) {
        this.map = map;
    }

    public void setAdditionalMaps(Path additionalMapsPath) {
        String[] additionalMapFilenames = additionalMapsPath.list();
        this.additionalMaps = new File[additionalMapFilenames.length];
        for (int i = 0; i < additionalMapFilenames.length; ++i) {
            this.additionalMaps[i] = new File(additionalMapFilenames[i]);
        }
    }

    public void setDestDir(File destDir) {
        this.generator.setDestDir(destDir);
    }

    public void setOverwrite(boolean overwrite) {
        this.generator.setOverwrite(overwrite);
    }

    public void setMakepairs(boolean makepairs) {
        this.generator.setMakePairs(makepairs);
    }

    public void setTemplate(String template) {
        this.generator.setTemplate(template);
    }

    public void setSupertemplate(String supertemplate) {
        this.generator.setSuperTemplate(supertemplate);
    }

    public void setUsepkgpath(boolean usepkgpath) {
        this.generator.setUsePkgPath(usepkgpath);
    }

    public void setSuperpkg(String superpkg) {
        this.generator.setSuperPkg(superpkg);
    }

    public void setClient(boolean client) {
        this.generator.setClient(client);
    }

    public void setVersion(String versionString) {
        try {
            this.generator.setVersionString(versionString);
        }
        catch (IllegalStateException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setEncoding(String encoding) {
        this.generator.setEncoding(encoding);
    }

    public void setExcludeEntities(String excludeEntitiesPattern) {
        this.excludeEntitiesPattern = excludeEntitiesPattern;
    }

    public void setIncludeEntities(String includeEntitiesPattern) {
        this.includeEntitiesPattern = includeEntitiesPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.generator.setOutputPattern(outputPattern);
    }

    public void setMode(String mode) {
        this.generator.setMode(mode);
    }

    public Object createConfig() {
        this.vppConfig = new VPPConfig();
        return this.vppConfig;
    }

    private void initializeVppConfig() {
        if (this.vppConfig == null) {
            this.vppConfig = VPPConfig.getDefaultConfig((Project)this.getProject());
        }
    }
}

