/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.project.NamedObjectFactory;
import org.objectstyle.cayenne.util.NameConverter;

public class EntityMergeSupport {
    protected DataMap map;
    static /* synthetic */ Class class$org$objectstyle$cayenne$map$ObjAttribute;
    static /* synthetic */ Class class$org$objectstyle$cayenne$map$ObjRelationship;

    public EntityMergeSupport(DataMap map) {
        this.map = map;
    }

    public void synchronizeWithDbEntities(Collection objEntities) {
        Iterator it = objEntities.iterator();
        while (it.hasNext()) {
            this.synchronizeWithDbEntity((ObjEntity)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null || entity.getDbEntity() == null) {
            return;
        }
        DataMap dataMap = this.map;
        synchronized (dataMap) {
            List removeAttributes = this.getAttributesToRemove(entity);
            Iterator rait = removeAttributes.iterator();
            while (rait.hasNext()) {
                DbAttribute da = (DbAttribute)rait.next();
                ObjAttribute oa = entity.getAttributeForDbAttribute(da);
                while (oa != null) {
                    String attrName = oa.getName();
                    entity.removeAttribute(attrName);
                    oa = entity.getAttributeForDbAttribute(da);
                }
            }
            List addAttributes = this.getAttributesToAdd(entity);
            Iterator ait = addAttributes.iterator();
            while (ait.hasNext()) {
                DbAttribute da = (DbAttribute)ait.next();
                String attrName = NameConverter.underscoredToJava(da.getName(), false);
                attrName = NamedObjectFactory.createName(class$org$objectstyle$cayenne$map$ObjAttribute == null ? EntityMergeSupport.class$("org.objectstyle.cayenne.map.ObjAttribute") : class$org$objectstyle$cayenne$map$ObjAttribute, entity, attrName);
                String type = TypesMapping.getJavaBySqlType(da.getType());
                ObjAttribute oa = new ObjAttribute(attrName, type, entity);
                oa.setDbAttribute(da);
                entity.addAttribute(oa);
            }
            List addRelationships = this.getRelationshipsToAdd(entity);
            Iterator rit = addRelationships.iterator();
            while (rit.hasNext()) {
                DbRelationship dr = (DbRelationship)rit.next();
                DbEntity dbEntity = (DbEntity)dr.getTargetEntity();
                Iterator targets = this.map.getMappedEntities(dbEntity).iterator();
                if (!targets.hasNext()) continue;
                Entity mappedTarget = (Entity)targets.next();
                String relationshipName = NameConverter.underscoredToJava(dr.getName(), false);
                relationshipName = NamedObjectFactory.createName(class$org$objectstyle$cayenne$map$ObjRelationship == null ? EntityMergeSupport.class$("org.objectstyle.cayenne.map.ObjRelationship") : class$org$objectstyle$cayenne$map$ObjRelationship, entity, relationshipName);
                ObjRelationship or = new ObjRelationship(relationshipName);
                or.addDbRelationship(dr);
                or.setSourceEntity(entity);
                or.setTargetEntity(mappedTarget);
                entity.addRelationship(or);
            }
        }
    }

    protected List getAttributesToRemove(ObjEntity objEntity) {
        ArrayList removeList = new ArrayList();
        Iterator it = objEntity.getDbEntity().getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship dbrel = (DbRelationship)it.next();
            if (dbrel.getName() == null) continue;
            Iterator srcAttIterator = dbrel.getSourceAttributes().iterator();
            while (srcAttIterator.hasNext()) {
                removeList.add(srcAttIterator.next());
            }
        }
        return removeList;
    }

    protected List getAttributesToAdd(ObjEntity objEntity) {
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Iterator it = objEntity.getDbEntity().getAttributes().iterator();
        Collection rels = objEntity.getDbEntity().getRelationships();
        while (it.hasNext()) {
            DbAttribute dba = (DbAttribute)it.next();
            if (objEntity.getAttributeForDbAttribute(dba) != null || dba.getName() == null || dba.isPrimaryKey()) continue;
            boolean isFK = false;
            Iterator rit = rels.iterator();
            block1: while (!isFK && rit.hasNext()) {
                DbRelationship rel = (DbRelationship)rit.next();
                Iterator jit = rel.getJoins().iterator();
                while (jit.hasNext()) {
                    DbJoin join = (DbJoin)jit.next();
                    if (join.getSource() != dba) continue;
                    isFK = true;
                    continue block1;
                }
            }
            if (isFK) continue;
            missing.add(dba);
        }
        return missing;
    }

    protected List getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        Iterator it = objEntity.getDbEntity().getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship dbrel = (DbRelationship)it.next();
            if (dbrel.getName() == null || objEntity.getRelationshipForDbRelationship(dbrel) != null) continue;
            missing.add(dbrel);
        }
        return missing;
    }

    public DataMap getMap() {
        return this.map;
    }

    public void setMap(DataMap map) {
        this.map = map;
    }
}

