/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.util.ResourceLocator;

public class WebApplicationResourceLocator
extends ResourceLocator {
    private static Logger logObj;
    protected ServletContext context;
    protected List additionalContextPaths = new ArrayList();

    public WebApplicationResourceLocator() {
        this.addFilesystemPath("/WEB-INF/");
    }

    public WebApplicationResourceLocator(ServletContext context) {
        this();
        this.setServletContext(context);
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public URL findResource(String location) {
        if (!this.additionalContextPaths.isEmpty() && this.getServletContext() != null) {
            String suffix;
            String string = suffix = location != null ? location : "";
            if (suffix.startsWith("/")) {
                suffix = suffix.substring(1);
            }
            Iterator cpi = this.additionalContextPaths.iterator();
            while (cpi.hasNext()) {
                String prefix = (String)cpi.next();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                String fullName = prefix + suffix;
                logObj.debug("searching for: " + fullName);
                try {
                    URL url = this.getServletContext().getResource(fullName);
                    if (url == null) continue;
                    return url;
                }
                catch (MalformedURLException ex) {
                    logObj.debug("Malformed URL, ignoring.", ex);
                }
            }
        }
        return super.findResource(location);
    }

    public void addFilesystemPath(String path) {
        if (path != null) {
            if (path.startsWith("/WEB-INF/")) {
                this.additionalContextPaths.add(path);
            } else {
                super.addFilesystemPath(path);
            }
        } else {
            throw new IllegalArgumentException("Path must not be null.");
        }
    }

    static {
        Predicate p = new Predicate(){

            public boolean evaluate(Object o) {
                return Configuration.isLoggingConfigured();
            }
        };
        logObj = new ResourceLocator.PredicateLogger(WebApplicationResourceLocator.class, p);
    }
}

