/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectstyle.cayenne.util.Util;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> en = zip.entries();
            int bufSize = 8192;
            while (en.hasMoreElements()) {
                File file;
                ZipEntry entry = en.nextElement();
                File file2 = file = destDir != null ? new File(destDir, entry.getName()) : new File(entry.getName());
                if (entry.isDirectory()) {
                    if (file.mkdirs()) continue;
                    throw new IOException("Error creating directory: " + file);
                }
                File parent = file.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Error creating directory: " + parent);
                }
                InputStream in = zip.getInputStream(entry);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), bufSize);
                    try {
                        Util.copyPipe(in, out, bufSize);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File zipFile, File parentDir, File[] sources, char pathSeparator) throws IOException {
        String stripPath;
        String string = stripPath = parentDir != null ? parentDir.getPath() : "";
        if (stripPath.length() > 0 && !stripPath.endsWith(File.separator)) {
            stripPath = stripPath + File.separator;
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        out.setMethod(8);
        try {
            for (int i = 0; i < sources.length; ++i) {
                if (!sources[i].exists()) {
                    throw new IllegalArgumentException("File or directory does not exist: " + sources[i]);
                }
                if (sources[i].isDirectory()) {
                    ZipUtil.zipDirectory(out, stripPath, sources[i], pathSeparator);
                    continue;
                }
                ZipUtil.zipFile(out, stripPath, sources[i], pathSeparator);
            }
        }
        finally {
            out.close();
        }
    }

    private static void zipDirectory(ZipOutputStream out, String stripPath, File dir, char pathSeparator) throws IOException {
        String[] entries = dir.list();
        if (entries == null || entries.length == 0) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            File file = new File(dir, entries[i]);
            if (file.isDirectory()) {
                ZipUtil.zipDirectory(out, stripPath, file, pathSeparator);
                continue;
            }
            ZipUtil.zipFile(out, stripPath, file, pathSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(ZipOutputStream out, String stripPath, File file, char pathSeparator) throws IOException {
        ZipEntry ze = new ZipEntry(ZipUtil.processPath(file.getPath(), stripPath, pathSeparator));
        ze.setTime(file.lastModified());
        out.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), buffer.length);
        try {
            int count = 0;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                if (count == 0) continue;
                out.write(buffer, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    private static String processPath(String path, String stripPath, char pathSeparator) {
        if (!path.startsWith(stripPath)) {
            throw new IllegalArgumentException("Invalid entry: " + path + "; expected to start with " + stripPath);
        }
        return path.substring(stripPath.length()).replace(File.separatorChar, pathSeparator);
    }
}

