/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.wocompat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.exp.ExpressionFactory;
import org.objectstyle.cayenne.exp.ExpressionParameter;
import org.objectstyle.cayenne.exp.parser.ASTObjPath;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.SelectQuery;
import org.objectstyle.cayenne.wocompat.EOObjEntity;

public class EOQuery
extends SelectQuery {
    protected Map plistMap;
    protected Map bindings;

    public EOQuery(ObjEntity root, Map plistMap) {
        super(root);
        this.plistMap = plistMap;
        this.initFromPlist(plistMap);
    }

    protected void initFromPlist(Map plistMap) {
        Map qualifierMap;
        List orderings;
        this.setResolvingInherited("YES".equalsIgnoreCase((String)plistMap.get("isDeep")));
        this.setRefreshingObjects("YES".equalsIgnoreCase((String)plistMap.get("refreshesRefetchedObjects")));
        this.setDistinct("YES".equalsIgnoreCase((String)plistMap.get("usesDistinct")));
        Object fetchLimit = plistMap.get("fetchLimit");
        if (fetchLimit != null) {
            try {
                if (fetchLimit instanceof Number) {
                    this.setFetchLimit(((Number)fetchLimit).intValue());
                } else {
                    this.setFetchLimit(Integer.parseInt(fetchLimit.toString()));
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((orderings = (List)plistMap.get("sortOrderings")) != null && !orderings.isEmpty()) {
            Iterator it = orderings.iterator();
            while (it.hasNext()) {
                boolean asc;
                Map ordering = (Map)it.next();
                boolean bl = asc = !"compareDescending:".equals(ordering.get("selectorName"));
                String key = (String)ordering.get("key");
                if (key == null) continue;
                this.addOrdering(key, asc);
            }
        }
        if ((qualifierMap = (Map)plistMap.get("qualifier")) != null && !qualifierMap.isEmpty()) {
            this.setQualifier(this.makeQualifier(qualifierMap));
        }
    }

    public String getEOName() {
        if (this.root instanceof EOObjEntity) {
            return ((EOObjEntity)this.root).localQueryName(this.getName());
        }
        return this.getName();
    }

    public Collection getBindingNames() {
        if (this.bindings == null) {
            this.initBindings();
        }
        return this.bindings.keySet();
    }

    public String bindingClass(String name) {
        if (this.bindings == null) {
            this.initBindings();
        }
        return (String)this.bindings.get(name);
    }

    private synchronized void initBindings() {
        if (this.bindings != null) {
            return;
        }
        this.bindings = new HashMap();
        if (!(this.root instanceof Entity)) {
            return;
        }
        Map qualifier = (Map)this.plistMap.get("qualifier");
        this.initBindings(this.bindings, (Entity)this.root, qualifier);
    }

    private void initBindings(Map bindings, Entity entity, Map qualifier) {
        if (qualifier == null) {
            return;
        }
        if ("EOKeyValueQualifier".equals(qualifier.get("class"))) {
            String key = (String)qualifier.get("key");
            if (key == null) {
                return;
            }
            Object value = qualifier.get("value");
            if (!(value instanceof Map)) {
                return;
            }
            Map valueMap = (Map)value;
            if (!"EOQualifierVariable".equals(valueMap.get("class")) || !valueMap.containsKey("_key")) {
                return;
            }
            String name = (String)valueMap.get("_key");
            String className = null;
            try {
                ObjEntity target;
                Object lastObject = new ASTObjPath(key).evaluate(entity);
                if (lastObject instanceof ObjAttribute) {
                    className = ((ObjAttribute)lastObject).getType();
                } else if (lastObject instanceof ObjRelationship && (target = (ObjEntity)((ObjRelationship)lastObject).getTargetEntity()) != null) {
                    className = target.getClassName();
                }
            }
            catch (ExpressionException ex) {
                className = "java.lang.Object";
            }
            if (className == null) {
                className = "java.lang.Object";
            }
            bindings.put(name, className);
            return;
        }
        List children = (List)qualifier.get("qualifiers");
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.initBindings(bindings, entity, (Map)it.next());
            }
        }
    }

    public synchronized Expression makeQualifier(Map qualifierMap) {
        if (qualifierMap == null) {
            return null;
        }
        return EOFetchSpecificationParser.makeQualifier(qualifierMap);
    }

    static class EOFetchSpecificationParser {
        public static final String IS_EQUAL_TO = "isEqualTo:";
        public static final String IS_NOT_EQUAL_TO = "isNotEqualTo:";
        public static final String IS_LIKE = "isLike:";
        public static final String CASE_INSENSITIVE_LIKE = "isCaseInsensitiveLike:";
        public static final String IS_LESS_THAN = "isLessThan:";
        public static final String IS_LESS_THAN_OR_EQUAL_TO = "isLessThanOrEqualTo:";
        public static final String IS_GREATER_THAN = "isGreaterThan:";
        public static final String IS_GREATER_THAN_OR_EQUAL_TO = "isGreaterThanOrEqualTo:";
        private static HashMap selectorToExpressionBridge;

        EOFetchSpecificationParser() {
        }

        public static HashMap selectorToExpressionBridge() {
            if (null == selectorToExpressionBridge) {
                selectorToExpressionBridge = new HashMap(8);
                selectorToExpressionBridge.put(IS_EQUAL_TO, new Integer(3));
                selectorToExpressionBridge.put(IS_NOT_EQUAL_TO, new Integer(4));
                selectorToExpressionBridge.put(IS_LIKE, new Integer(11));
                selectorToExpressionBridge.put(CASE_INSENSITIVE_LIKE, new Integer(12));
                selectorToExpressionBridge.put(IS_LESS_THAN, new Integer(5));
                selectorToExpressionBridge.put(IS_LESS_THAN_OR_EQUAL_TO, new Integer(7));
                selectorToExpressionBridge.put(IS_GREATER_THAN, new Integer(6));
                selectorToExpressionBridge.put(IS_GREATER_THAN_OR_EQUAL_TO, new Integer(8));
            }
            return selectorToExpressionBridge;
        }

        public static boolean isAggregate(Map qualifier) {
            boolean result = true;
            String theClass = (String)qualifier.get("class");
            if (theClass == null) {
                return false;
            }
            if (theClass.equalsIgnoreCase("EOKeyValueQualifier") || theClass.equalsIgnoreCase("EOKeyComparisonQualifier")) {
                result = false;
            }
            return result;
        }

        public static int expressionTypeForQualifier(Map qualifierMap) {
            String selector = (String)qualifierMap.get("selectorName");
            return EOFetchSpecificationParser.expressionTypeForSelector(selector);
        }

        public static int expressionTypeForSelector(String selector) {
            Integer expType = (Integer)EOFetchSpecificationParser.selectorToExpressionBridge().get(selector);
            return expType != null ? expType : -1;
        }

        public static int aggregateExpressionClassForQualifier(Map qualifierMap) {
            String qualifierClass = (String)qualifierMap.get("class");
            if (qualifierClass != null) {
                if (qualifierClass.equalsIgnoreCase("EOAndQualifier")) {
                    return 0;
                }
                if (qualifierClass.equalsIgnoreCase("EOOrQualifier")) {
                    return 1;
                }
                if (qualifierClass.equalsIgnoreCase("EONotQualifier")) {
                    return 2;
                }
            }
            return -1;
        }

        public static Expression makeQualifier(Map qualifierMap) {
            if (EOFetchSpecificationParser.isAggregate(qualifierMap)) {
                int aggregateClass = EOFetchSpecificationParser.aggregateExpressionClassForQualifier(qualifierMap);
                if (aggregateClass == 2) {
                    Map child = (Map)qualifierMap.get("qualifier");
                    Expression childExp = EOFetchSpecificationParser.makeQualifier(child);
                    return childExp.notExp();
                }
                List children = (List)qualifierMap.get("qualifiers");
                if (children != null) {
                    ArrayList<Expression> childExpressions = new ArrayList<Expression>();
                    Iterator it = children.iterator();
                    while (it.hasNext()) {
                        Expression childExp = EOFetchSpecificationParser.makeQualifier((Map)it.next());
                        childExpressions.add(childExp);
                    }
                    return ExpressionFactory.joinExp(aggregateClass, childExpressions);
                }
            }
            int expType = EOFetchSpecificationParser.expressionTypeForQualifier(qualifierMap);
            String qualifierClass = (String)qualifierMap.get("class");
            String key = null;
            Object comparisonValue = null;
            if ("EOKeyComparisonQualifier".equals(qualifierClass)) {
                key = (String)qualifierMap.get("leftValue");
                comparisonValue = (String)qualifierMap.get("rightValue");
                return null;
            }
            if ("EOKeyValueQualifier".equals(qualifierClass)) {
                key = (String)qualifierMap.get("key");
                Object value = qualifierMap.get("value");
                if (value instanceof Map) {
                    Map valueMap = (Map)value;
                    String objClass = (String)valueMap.get("class");
                    if ("EOQualifierVariable".equals(objClass) && valueMap.containsKey("_key")) {
                        String paramName = (String)valueMap.get("_key");
                        comparisonValue = new ExpressionParameter(paramName);
                    } else {
                        Object queryVal = valueMap.get("value");
                        comparisonValue = "NSNumber".equals(objClass) ? (Number)queryVal : ("EONull".equals(objClass) ? null : queryVal);
                    }
                } else if (value instanceof String) {
                    comparisonValue = value;
                }
            }
            switch (expType) {
                case 3: {
                    return ExpressionFactory.matchExp(key, comparisonValue);
                }
                case 4: {
                    return ExpressionFactory.noMatchExp(key, comparisonValue);
                }
                case 11: {
                    return ExpressionFactory.likeExp(key, comparisonValue);
                }
                case 12: {
                    return ExpressionFactory.likeIgnoreCaseExp(key, comparisonValue);
                }
                case 5: {
                    return ExpressionFactory.lessExp(key, comparisonValue);
                }
                case 7: {
                    return ExpressionFactory.lessOrEqualExp(key, comparisonValue);
                }
                case 6: {
                    return ExpressionFactory.greaterExp(key, comparisonValue);
                }
                case 8: {
                    return ExpressionFactory.greaterOrEqualExp(key, comparisonValue);
                }
            }
            return null;
        }
    }
}

