/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.ujac.chart.ChartItem;
import org.ujac.chart.ChartItemPosition;

public abstract class BaseChartItem
implements ChartItem {
    protected ChartItemPosition position = null;
    protected Rectangle2D outputArea = null;

    public BaseChartItem(ChartItemPosition position) {
        this.position = position;
    }

    public ChartItemPosition getPosition() {
        return this.position;
    }

    public Rectangle2D getOutputArea(Rectangle2D viewport, Graphics2D graphics) {
        if (this.outputArea == null) {
            this.outputArea = this.calculateOutputArea(viewport, graphics);
        }
        return this.outputArea;
    }

    public void resetMetrics() {
        this.outputArea = null;
    }

    protected abstract Rectangle2D calculateOutputArea(Rectangle2D var1, Graphics2D var2);

    public double getWidth(Rectangle2D viewport, Graphics2D graphics) {
        return this.getOutputArea(viewport, graphics).getWidth();
    }

    public double getHeight(Rectangle2D viewport, Graphics2D graphics) {
        return this.getOutputArea(viewport, graphics).getHeight();
    }

    public void move(double x, double y) {
        double curX = 0.0;
        double curY = 0.0;
        double curWidth = 0.0;
        double curHeight = 0.0;
        if (this.outputArea != null) {
            curX = this.outputArea.getX();
            curY = this.outputArea.getY();
            curWidth = this.outputArea.getWidth();
            curHeight = this.outputArea.getHeight();
        }
        if (x != 0.0 && this.position.getHorizontalPositionMode() == 0) {
            this.position.setX(this.position.getX() + x);
            curX = this.position.getX();
        }
        if (y != 0.0 && this.position.getVerticalPositionMode() == 0) {
            this.position.setY(this.position.getY() + y);
            curY = this.position.getY();
        }
        if (this.outputArea != null) {
            this.outputArea.setFrame(curX, curY, curWidth, curHeight);
        }
    }

    public void moveTo(double x, double y) {
        double curX = 0.0;
        double curY = 0.0;
        double curWidth = 0.0;
        double curHeight = 0.0;
        if (this.outputArea != null) {
            curX = this.outputArea.getX();
            curY = this.outputArea.getY();
            curWidth = this.outputArea.getWidth();
            curHeight = this.outputArea.getHeight();
        }
        if (x != 0.0 && this.position.getHorizontalPositionMode() == 0) {
            this.position.setX(x);
            curX = this.position.getX();
        }
        if (y != 0.0 && this.position.getVerticalPositionMode() == 0) {
            this.position.setY(y);
            curY = this.position.getY();
        }
        if (this.outputArea != null) {
            this.outputArea.setFrame(curX, curY, curWidth, curHeight);
        }
    }

    public void alignItem(Rectangle2D viewport) {
        double xPos = this.outputArea.getX();
        double yPos = this.outputArea.getY();
        double width = this.outputArea.getWidth();
        double height = this.outputArea.getHeight();
        switch (this.position.getHorizontalPositionMode()) {
            case 0: {
                break;
            }
            case 2: {
                xPos = viewport.getCenterX() - width / 2.0;
                break;
            }
            case 3: {
                xPos = viewport.getX() + viewport.getWidth() - width;
                break;
            }
            default: {
                xPos = viewport.getX();
            }
        }
        switch (this.position.getVerticalPositionMode()) {
            case 0: {
                break;
            }
            case 5: {
                yPos = viewport.getCenterY() - height / 2.0;
                break;
            }
            case 6: {
                yPos = viewport.getY() + viewport.getHeight() - height;
                break;
            }
            default: {
                yPos = viewport.getY();
            }
        }
        this.outputArea.setFrame(xPos, yPos, width, height);
    }
}

