/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujac.chart.TextChartItem;

public class ChartAttributes {
    private Map attributes = null;

    public ChartAttributes() {
        this.attributes = new HashMap();
    }

    public ChartAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public boolean isDefined(String name) {
        return this.attributes.get(name) != null;
    }

    public boolean getBoolean(String name) {
        Boolean value = (Boolean)this.attributes.get(name);
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setBoolean(String name, boolean value) {
        this.attributes.put(name, new Boolean(value));
    }

    public int getInt(String name) {
        Number value = (Number)this.attributes.get(name);
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    public void setInt(String name, int value) {
        this.attributes.put(name, new Integer(value));
    }

    public double getLong(String name) {
        Number value = (Number)this.attributes.get(name);
        if (value == null) {
            return 0.0;
        }
        return value.longValue();
    }

    public void setLong(String name, long value) {
        this.attributes.put(name, new Long(value));
    }

    public float getFloat(String name) {
        Number value = (Number)this.attributes.get(name);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    public void setFloat(String name, float value) {
        this.attributes.put(name, new Float(value));
    }

    public double getDouble(String name) {
        Number value = (Number)this.attributes.get(name);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public void setDouble(String name, double value) {
        this.attributes.put(name, new Double(value));
    }

    public String getString(String name) {
        Object value = this.attributes.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void setString(String name, String value) {
        this.attributes.put(name, value);
    }

    public String[] getStringArray(String name) {
        List values = this.getList(name);
        int numValues = values.size();
        String[] strings = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            strings[i] = value.toString();
        }
        return strings;
    }

    public Font getFont(String name) {
        Font value = (Font)this.attributes.get(name);
        return value;
    }

    public void setFont(String name, Font value) {
        this.attributes.put(name, value);
    }

    public Color getColor(String name) {
        Color value = (Color)this.attributes.get(name);
        return value;
    }

    public void setColor(String name, Color value) {
        this.attributes.put(name, value);
    }

    public Color[] getColorArray(String name) {
        List values = this.getList(name);
        int numValues = values.size();
        Color[] colors = new Color[numValues];
        for (int i = 0; i < numValues; ++i) {
            colors[i] = (Color)values.get(i);
        }
        return colors;
    }

    public Object getObject(String name) {
        Object value = this.attributes.get(name);
        return value;
    }

    public void setObject(String name, Object value) {
        this.attributes.put(name, value);
    }

    public List getList(String name) {
        List value = (List)this.attributes.get(name);
        return value;
    }

    public void setList(String name, List value) {
        this.attributes.put(name, value);
    }

    public TextChartItem getTextItem(String name) {
        Object value = this.attributes.get(name);
        return (TextChartItem)value;
    }

    public void setTextItem(String name, TextChartItem value) {
        this.attributes.put(name, value);
    }
}

