/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.util.List;
import org.ujac.chart.ChartModel;
import org.ujac.chart.TextChartItem;

public class DefaultChartModel
implements ChartModel {
    protected TextChartItem title = null;
    protected List chartData = null;
    protected List areaLabels = null;
    protected List segmentLabels = null;
    protected double minValue = 0.0;
    protected double maxValue = 0.0;

    public TextChartItem getTitle() {
        return this.title;
    }

    public void setTitle(TextChartItem title) {
        this.title = title;
    }

    public List getChartData() {
        return this.chartData;
    }

    public void setChartData(List chartData) {
        this.chartData = chartData;
        if (chartData == null) {
            return;
        }
        int numSegments = chartData.size();
        double min = this.minValue;
        double max = this.maxValue;
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])chartData.get(i);
            for (int j = 0; j < row.length; ++j) {
                double val = row[j];
                min = Math.min(min, val);
                max = Math.max(max, val);
            }
        }
        this.minValue = Math.min(this.minValue, min);
        this.maxValue = Math.max(this.maxValue, max);
    }

    public List getAreaLabels() {
        return this.areaLabels;
    }

    public void setAreaLabels(List areaLabels) {
        this.areaLabels = areaLabels;
    }

    public List getSegmentLabels() {
        return this.segmentLabels;
    }

    public void setSegmentLabels(List segmentLabels) {
        this.segmentLabels = segmentLabels;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public int getNumSegments() {
        return this.chartData.size();
    }

    public int getNumAreas() {
        int numAreas = 0;
        int numSegments = this.chartData.size();
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])this.chartData.get(i);
            numAreas = Math.max(numAreas, row.length);
        }
        return numAreas;
    }
}

