/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.text.NumberFormat;
import java.util.ArrayList;
import org.ujac.chart.ChartException;

public class DescriptionPattern {
    private String pattern = null;
    private PatternItem[] patternItems = null;
    private NumberFormat valueNumberFormat = null;
    private NumberFormat percentNumberFormat = null;
    private double value = 0.0;
    private double percent = 0.0;
    private String segmentLabel = null;
    private String areaLabel = null;

    public DescriptionPattern(String pattern, NumberFormat valueNumberFormat, NumberFormat percentNumberFormat) throws ChartException {
        this.pattern = pattern;
        this.valueNumberFormat = valueNumberFormat;
        this.percentNumberFormat = percentNumberFormat;
        this.compile();
    }

    private void compile() throws ChartException {
        int i;
        ArrayList<PatternItem> patternItemList = new ArrayList<PatternItem>();
        char[] patternChars = this.pattern.toCharArray();
        int lastOffset = 0;
        block7: for (i = 0; i < patternChars.length; ++i) {
            switch (patternChars[i]) {
                case '%': {
                    if (i >= patternChars.length - 1) continue block7;
                    char c = patternChars[i + 1];
                    switch (c) {
                        case '%': {
                            patternItemList.add(new StaticItem(new String(patternChars, lastOffset, i - lastOffset + 1)));
                            lastOffset = ++i + 1;
                            continue block7;
                        }
                        case 'a': 
                        case 'p': 
                        case 's': 
                        case 'v': {
                            if (lastOffset < i) {
                                patternItemList.add(new StaticItem(new String(patternChars, lastOffset, i - lastOffset)));
                            }
                            lastOffset = ++i + 1;
                            if (c == 's') {
                                patternItemList.add(new SegmentLabelItem());
                                continue block7;
                            }
                            if (c == 'a') {
                                patternItemList.add(new AreaLabelItem());
                                continue block7;
                            }
                            if (c == 'v') {
                                patternItemList.add(new ValueItem());
                                continue block7;
                            }
                            if (c != 'p') continue block7;
                            patternItemList.add(new PercentItem());
                            continue block7;
                        }
                        default: {
                            throw new ChartException("Unsupported token in pattern '" + this.pattern + "' at pos " + i + ".");
                        }
                    }
                }
            }
        }
        if (lastOffset < patternChars.length) {
            patternItemList.add(new StaticItem(new String(patternChars, lastOffset, patternChars.length - lastOffset)));
        }
        this.patternItems = new PatternItem[patternItemList.size()];
        for (i = 0; i < this.patternItems.length; ++i) {
            this.patternItems[i] = (PatternItem)patternItemList.get(i);
        }
    }

    public String apply(double value, double percent, String segmentLabel, String areaLabel) {
        this.value = value;
        this.percent = percent;
        this.segmentLabel = segmentLabel;
        this.areaLabel = areaLabel;
        StringBuffer outBuf = new StringBuffer();
        for (int i = 0; i < this.patternItems.length; ++i) {
            PatternItem patternItem = this.patternItems[i];
            outBuf.append(patternItem.getContent());
        }
        return outBuf.toString();
    }

    public String getSegmentLabel() {
        return this.segmentLabel;
    }

    public String getAreaLabel() {
        return this.areaLabel;
    }

    public String getValue() {
        return this.valueNumberFormat.format(this.value);
    }

    public String getPercent() {
        return this.percentNumberFormat.format(this.percent);
    }

    private class PercentItem
    implements PatternItem {
        public String getContent() {
            return DescriptionPattern.this.getPercent();
        }
    }

    private class ValueItem
    implements PatternItem {
        public String getContent() {
            return DescriptionPattern.this.getValue();
        }
    }

    private class AreaLabelItem
    implements PatternItem {
        public String getContent() {
            return DescriptionPattern.this.getAreaLabel();
        }
    }

    private class SegmentLabelItem
    implements PatternItem {
        public String getContent() {
            return DescriptionPattern.this.getSegmentLabel();
        }
    }

    private class StaticItem
    implements PatternItem {
        private String content = null;

        public StaticItem(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }

    private static interface PatternItem {
        public String getContent();
    }
}

