/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.ujac.chart.Base2DScaleChart;
import org.ujac.chart.ChartException;

public class LineChart2D
extends Base2DScaleChart {
    public boolean getFillArea() {
        if (this.attributes.isDefined("fill-area")) {
            return this.attributes.getBoolean("fill-area");
        }
        return false;
    }

    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        Rectangle2D localViewport = super.draw(viewport, graphics);
        if (this.model == null || this.model.getChartData() == null) {
            return localViewport;
        }
        Rectangle effectiveViewport = this.calcViewport(localViewport, graphics);
        this.drawScale(localViewport, effectiveViewport, graphics);
        this.drawLegend(localViewport, graphics);
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(this.getLineWidth(), 1, 1));
        Color[] segmentColors = this.attributes.getColorArray("segment-colors");
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        boolean fillArea = this.getFillArea();
        float baseLineY = this.calculateBaseLinePosition();
        GeneralPath[] segmentPaths = new GeneralPath[this.model.getNumAreas()];
        GeneralPath[] segmentAreas = new GeneralPath[this.model.getNumAreas()];
        for (int i = 0; i < numSegments; ++i) {
            double[] row = (double[])chartData.get(i);
            float curPos = this.horizontalPositions[i];
            for (int j = 0; j < row.length; ++j) {
                float yPos;
                if (i == 0) {
                    yPos = this.calculateVerticalPosition(row[j]);
                    segmentPaths[j] = new GeneralPath();
                    segmentPaths[j].moveTo(curPos, yPos);
                    if (!fillArea) continue;
                    segmentAreas[j] = new GeneralPath();
                    segmentAreas[j].moveTo(curPos, baseLineY);
                    segmentAreas[j].lineTo(curPos, yPos);
                    continue;
                }
                yPos = this.calculateVerticalPosition(row[j]);
                segmentPaths[j].lineTo(curPos, yPos);
                if (!fillArea) continue;
                segmentAreas[j].lineTo(curPos, yPos);
                if (i != numSegments - 1) continue;
                segmentAreas[j].lineTo(curPos, baseLineY);
            }
        }
        for (int j = 0; j < segmentPaths.length; ++j) {
            Color color = segmentColors[j];
            if (fillArea) {
                graphics.setColor(this.getFillColor(color));
                graphics.fill(segmentAreas[j]);
            }
            graphics.setColor(color);
            graphics.draw(segmentPaths[j]);
        }
        graphics.setStroke(oldStroke);
        return localViewport;
    }

    private Color getFillColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b, 128);
    }
}

