/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.ujac.chart.Base2DStackedChart;
import org.ujac.chart.ChartException;

public class StackedBarChart2D
extends Base2DStackedChart {
    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        float yPos;
        int j;
        float yOffset;
        float curPos;
        int i;
        float shadowOffsetX;
        Rectangle2D localViewport = super.draw(viewport, graphics);
        if (this.model == null || this.model.getChartData() == null) {
            return localViewport;
        }
        Color[] segmentColors = this.attributes.getColorArray("segment-colors");
        List chartData = this.model.getChartData();
        int numSegments = chartData.size();
        Rectangle effectiveViewport = this.calcViewport(localViewport, graphics);
        this.drawScale(localViewport, effectiveViewport, graphics);
        this.drawLegend(localViewport, graphics);
        float horizontalScale = this.horizontalScale;
        float barsWidth = horizontalScale * 0.8f;
        float nullPos = this.calculateBaseLinePosition();
        double[] row = (double[])chartData.get(0);
        float barStep = barsWidth;
        float barWidth = barStep * 0.8f;
        float barOffset = -(barsWidth / 2.0f) * 0.8f;
        float shadowOffsetY = shadowOffsetX = this.getShadowLength();
        if (shadowOffsetY > 2.0f) {
            shadowOffsetY -= 1.0f;
        }
        if (shadowOffsetX > 0.0f) {
            graphics.setColor(this.getShadowColor());
            for (i = 0; i < numSegments; ++i) {
                row = (double[])chartData.get(i);
                curPos = this.horizontalPositions[i];
                yOffset = nullPos;
                for (j = 0; j < row.length; ++j) {
                    yPos = this.calculateVerticalPosition(row[j]);
                    if (yOffset < nullPos) {
                        yPos -= nullPos - yOffset;
                    }
                    float barOffs = barOffset;
                    graphics.fill(new Rectangle2D.Float(curPos + barOffs + shadowOffsetX, yPos + shadowOffsetY, barWidth, yOffset - yPos));
                    yOffset = yPos;
                }
            }
        }
        for (i = 0; i < numSegments; ++i) {
            row = (double[])chartData.get(i);
            curPos = this.horizontalPositions[i];
            yOffset = nullPos;
            for (j = 0; j < row.length; ++j) {
                yPos = this.calculateVerticalPosition(row[j]);
                if (yOffset < nullPos) {
                    yPos -= nullPos - yOffset;
                }
                int barOffs = (int)barOffset;
                graphics.setColor(segmentColors[j]);
                graphics.fill(new Rectangle2D.Float(curPos + (float)barOffs, yPos, barWidth, yOffset - yPos));
                yOffset = yPos;
            }
        }
        return localViewport;
    }
}

