/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.awt.Color;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;

public abstract class AbstractTagTest {
    public static final int TEST_OPEN = 1;
    public static final int TEST_CLOSE = 2;
    private int testMode = 2;
    private boolean testPassed = false;
    protected BaseDocumentTag tag = null;

    public AbstractTagTest() {
    }

    public AbstractTagTest(int testMode) {
        this.testMode = testMode;
    }

    protected void setup(BaseDocumentTag tag) {
        this.tag = tag;
    }

    public abstract void performTest() throws DocumentHandlerException;

    protected void doIt() throws DocumentHandlerException {
        this.performTest();
        this.testPassed = true;
    }

    public BaseDocumentTag getTag() {
        return this.tag;
    }

    public int getTestMode() {
        return this.testMode;
    }

    public boolean isTestPassed() {
        return this.testPassed;
    }

    protected String getStringAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getStringAttribute(ad, true, null);
    }

    protected String getStringStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getStringAttribute(null, true, ad);
    }

    protected float getFloatAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getFloatAttribute(ad, true, null);
    }

    protected float getFloatStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getFloatAttribute(null, true, ad);
    }

    protected int getIntegerAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getIntegerAttribute(ad, true, null);
    }

    protected int getIntegerStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getIntegerAttribute(null, true, ad);
    }

    protected float getDimensionAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getDimensionAttribute(ad, true, null);
    }

    protected float getDimensionStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getDimensionAttribute(null, true, ad);
    }

    protected boolean getBooleanAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getBooleanAttribute(ad, true, null);
    }

    protected boolean getBooleanStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getBooleanAttribute(null, true, ad);
    }

    protected Color getColorAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getColorAttribute(ad, true, null);
    }

    protected Color getColorStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getColorAttribute(null, true, ad);
    }

    protected int getHorizontalAlignmentAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getHorizontalAlignmentAttribute(ad, true, null);
    }

    protected int getHorizontalAlignmentStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getHorizontalAlignmentAttribute(null, true, ad);
    }

    protected int getVerticalAlignmentAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getAttributeDefinition(name);
        return this.tag.getVerticalAlignmentAttribute(ad, true, null);
    }

    protected int getVerticalAlignmentStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition ad = this.tag.getStyleAttributeDefinition(name);
        return this.tag.getVerticalAlignmentAttribute(null, true, ad);
    }

    protected String getContent() {
        String content = this.tag.getActualContent();
        return content;
    }
}

