/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AttributeDefinition {
    public static final int TYPE_INT = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_COLOR = 5;
    public static final int TYPE_BORDER = 6;
    public static final int TYPE_HORIZONTAL_ALIGNMENT = 7;
    public static final int TYPE_VERTICAL_ALIGNMENT = 8;
    public static final int TYPE_PAGE_SIZE = 9;
    public static final int TYPE_FONT_FAMILY = 10;
    public static final int TYPE_FONT_STYLE = 11;
    public static final int TYPE_NAME = 12;
    public static final int TYPE_ENUM = 13;
    public static final int TYPE_DIMENSION = 14;
    private String name = null;
    private int type;
    private boolean required;
    private String description = null;
    private String deprecation = null;
    private String[] possibleValues = null;
    private Set aliases = new HashSet();

    public AttributeDefinition(String name, int type, boolean required, String description) {
        this.name = name;
        this.type = type;
        this.required = required;
        this.description = description;
    }

    public AttributeDefinition(String name, int type, boolean required, String description, String[] aliases) {
        this(name, type, required, description);
        this.addAliases(aliases);
    }

    public AttributeDefinition(String name, int type, boolean required, String description, String deprecation) {
        this(name, type, required, description);
        this.deprecation = deprecation;
    }

    public AttributeDefinition(String name, String[] possibleValues, boolean required, String description) {
        this(name, 13, required, description);
        this.possibleValues = possibleValues;
    }

    public AttributeDefinition(String name, String[] possibleValues, boolean required, String description, String deprecation) {
        this(name, 13, required, description);
        this.possibleValues = possibleValues;
        this.deprecation = deprecation;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public AttributeDefinition setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AttributeDefinition setDeprecation(String deprecation) {
        this.deprecation = deprecation;
        return this;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public AttributeDefinition addAliases(String[] aliases) {
        if (aliases == null || aliases.length < 1) {
            return this;
        }
        for (int i = 0; i < aliases.length; ++i) {
            this.aliases.add(aliases[i]);
        }
        return this;
    }

    public AttributeDefinition addAlias(String alias) {
        if (alias == null || alias.length() < 1) {
            return this;
        }
        this.aliases.add(alias);
        return this;
    }

    public boolean checkAlias(String alias) {
        if (alias == null || alias.length() < 1) {
            return false;
        }
        return this.aliases.contains(alias);
    }

    public Collection getAliases() {
        return this.aliases;
    }

    public AttributeDefinition cloneAttrDef() {
        AttributeDefinition clone = new AttributeDefinition(this.name, this.type, this.required, this.description);
        clone.deprecation = this.deprecation;
        clone.possibleValues = this.possibleValues;
        clone.aliases.addAll(this.aliases);
        return clone;
    }

    public AttributeDefinition cloneAttrDef(String description) {
        AttributeDefinition clone = this.cloneAttrDef();
        clone.description = description;
        return clone;
    }
}

