/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ujac.print.ContentFilter;
import org.ujac.print.DefaultContentFilter;
import org.ujac.print.DefaultDocumentTagFactory;
import org.ujac.print.DocumentDataAccessor;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentMetaData;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.DocumentTagInterceptor;
import org.ujac.util.console.CommandLineHelper;
import org.ujac.util.io.FileResourceLoader;
import org.ujac.util.io.NullDeviceOutputStream;
import org.ujac.util.io.ResourceLoader;
import org.ujac.util.table.Column;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.TableException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.xml.XmlUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentPrinter {
    private InputSource templateSource = null;
    private DocumentTagFactory tagFactory = null;
    private TemplateInterpreter templateInterpeter = null;
    private FormatHelper formatHelper = null;
    private Map properties = null;
    private String xmlReaderClass = null;
    private ResourceLoader resourceLoader = null;
    private DocumentDataAccessor dataAccessor = null;
    private DocumentTagInterceptor tagInterceptor = null;
    private ContentFilter contentFilter = new DefaultContentFilter();
    private List modules = null;
    private DocumentMetaData metaData = null;
    private boolean translateEscapeSequences = true;
    private boolean parseDynamicContent = true;
    private boolean evaluateExpressions = true;
    private boolean cacheImages = true;
    private boolean strictlyCheckDocumentStructure = true;
    private int expectedNumberOfPages = 999;
    private boolean pageNumberingStartsAfterHead = true;

    public DocumentPrinter() {
        this(null);
    }

    public DocumentPrinter(DocumentTagFactory tagFactory) {
        this(null, tagFactory);
    }

    public DocumentPrinter(InputStream templateStream, Map properties) {
        this(properties, null);
        this.templateSource = new InputSource(templateStream);
    }

    public DocumentPrinter(InputStream templateStream, Map properties, DocumentTagFactory tagFactory) {
        this(properties, tagFactory);
        this.templateSource = new InputSource(templateStream);
    }

    public DocumentPrinter(Reader templateReader, Map properties) {
        this(properties, null);
        this.templateSource = new InputSource(templateReader);
    }

    public DocumentPrinter(Reader templateReader, Map properties, DocumentTagFactory tagFactory) {
        this(properties, tagFactory);
        this.templateSource = new InputSource(templateReader);
    }

    private DocumentPrinter(Map properties, DocumentTagFactory tagFactory) {
        this.properties = properties;
        this.tagFactory = tagFactory == null ? DefaultDocumentTagFactory.getInstance() : tagFactory;
    }

    public TemplateInterpreter getTemplateInterpreter() {
        return this.templateInterpeter;
    }

    public void setTemplateInterpreter(TemplateInterpreter templateInterpeter) {
        this.templateInterpeter = templateInterpeter;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.formatHelper = formatHelper;
    }

    public void setTemplateSource(InputStream templateStream) {
        this.templateSource = new InputSource(templateStream);
    }

    public void setTemplateSource(Reader templateReader) {
        this.templateSource = new InputSource(templateReader);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getXmlReaderClass() {
        return this.xmlReaderClass;
    }

    public void setXmlReaderClass(String xmlReaderClass) {
        if (xmlReaderClass != null) {
            this.xmlReaderClass = xmlReaderClass;
        }
    }

    protected XMLReader createXmlReader() throws SAXException {
        return XmlUtils.createXmlReader(this.getXmlReaderClass());
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setDataAccessor(DocumentDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public DocumentTagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public void setTagInterceptor(DocumentTagInterceptor tagInterceptor) {
        this.tagInterceptor = tagInterceptor;
    }

    public ContentFilter getContentFilter() {
        return this.contentFilter;
    }

    public void setContentFilter(ContentFilter contentFilter) {
        this.contentFilter = contentFilter;
    }

    public boolean isTranslateEscapeSequences() {
        return this.translateEscapeSequences;
    }

    public void setTranslateEscapeSequences(boolean translateEscapeSequences) {
        this.translateEscapeSequences = translateEscapeSequences;
    }

    public boolean isParseDynamicContent() {
        return this.parseDynamicContent;
    }

    public void setParseDynamicContent(boolean parseDynamicContent) {
        this.parseDynamicContent = parseDynamicContent;
    }

    public boolean isEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public void setEvaluateExpressions(boolean evaluateExpressions) {
        this.evaluateExpressions = evaluateExpressions;
    }

    public boolean isCacheImages() {
        return this.cacheImages;
    }

    public void setCacheImages(boolean cacheImages) {
        this.cacheImages = cacheImages;
    }

    public boolean isStrictlyCheckDocumentStructure() {
        return this.strictlyCheckDocumentStructure;
    }

    public void setStrictlyCheckDocumentStructure(boolean strictlyCheckDocumentStructure) {
        this.strictlyCheckDocumentStructure = strictlyCheckDocumentStructure;
    }

    public int getExpectedNumberOfPages() {
        return this.expectedNumberOfPages;
    }

    public void setExpectedNumberOfPages(int expectedNumberOfPages) {
        this.expectedNumberOfPages = expectedNumberOfPages;
    }

    public boolean isPageNumberingStartsAfterHead() {
        return this.pageNumberingStartsAfterHead;
    }

    public void setPageNumberingStartsAfterHead(boolean pageNumberingStartsAfterHead) {
        this.pageNumberingStartsAfterHead = pageNumberingStartsAfterHead;
    }

    public void loadModule(String modulePath) throws IOException {
        byte[] moduleCode = this.resourceLoader.loadResource(modulePath);
        if (this.modules == null) {
            this.modules = new ArrayList();
        }
        this.modules.add(moduleCode);
    }

    public DocumentHandler printDocument(OutputStream outputStream) throws DocumentHandlerException, IOException {
        return this.printDocument(outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentHandler printDocument(OutputStream outputStream, boolean supportToc) throws DocumentHandlerException, IOException {
        this.removeInternalDocumentProperties();
        if (!supportToc) {
            return this.printDocument(this.createDocumentHandler(outputStream), this.templateSource, this.modules);
        }
        File tmpSourceFile = null;
        NullDeviceOutputStream mainDocumentStream = null;
        DocumentHandler documentHandler = null;
        int numPages = 0;
        PrintWriter templateCopyWriter = null;
        try {
            tmpSourceFile = File.createTempFile("ujac_print", "xml");
            mainDocumentStream = new NullDeviceOutputStream();
            documentHandler = this.createDocumentHandler(mainDocumentStream);
            documentHandler.setDestinationsSupported(false);
            documentHandler.clearReferences();
            documentHandler.setPageNumberOffset(0);
            documentHandler.setIncludeHeadSection(false);
            templateCopyWriter = new PrintWriter(new FileWriter(tmpSourceFile));
            documentHandler.setTemplateCopyWriter(templateCopyWriter);
            this.printDocument(documentHandler, this.templateSource, this.modules);
            numPages = (Integer)documentHandler.getTemplateContext().get("pageNumber");
        }
        finally {
            documentHandler.setTemplateCopyWriter(null);
            if (templateCopyWriter != null) {
                templateCopyWriter.close();
            }
        }
        try {
            documentHandler.setIncludeHeadSection(true);
            this.removeInternalDocumentProperties();
            if (this.pageNumberingStartsAfterHead) {
                documentHandler.setTocFreezed(true);
                documentHandler.resetReferences();
            } else {
                documentHandler.setTocFreezed(false);
                documentHandler.clearReferences();
            }
            documentHandler.reset(new NullDeviceOutputStream());
            this.printDocument(documentHandler, new InputSource(new FileReader(tmpSourceFile)), null);
            int numPagesInclToc = (Integer)documentHandler.getTemplateContext().get("pageNumber");
            if (!this.pageNumberingStartsAfterHead) {
                this.removeInternalDocumentProperties();
                documentHandler.setTocFreezed(false);
                documentHandler.resetReferences();
                documentHandler.reset(new NullDeviceOutputStream());
                this.printDocument(documentHandler, new InputSource(new FileReader(tmpSourceFile)), null);
            }
            this.removeInternalDocumentProperties();
            if (this.pageNumberingStartsAfterHead) {
                documentHandler.setTocFreezed(true);
                documentHandler.resetReferences();
            } else {
                documentHandler.setTocFreezed(false);
                documentHandler.resetReferences();
            }
            documentHandler.reset(outputStream);
            int offset = 0;
            if (this.pageNumberingStartsAfterHead) {
                offset = numPages - numPagesInclToc;
            }
            documentHandler.setPageNumberOffset(offset);
            documentHandler.setDestinationsSupported(true);
            DocumentHandler documentHandler2 = this.printDocument(documentHandler, new InputSource(new FileReader(tmpSourceFile)), null);
            return documentHandler2;
        }
        finally {
            tmpSourceFile.delete();
        }
    }

    protected void removeInternalDocumentProperties() {
        if (this.properties != null) {
            this.properties.remove("chapterId");
            this.properties.remove("main_document");
            this.properties.remove("body");
            this.properties.remove("tocItem");
            this.properties.remove("pageNumber");
        }
    }

    protected DocumentHandler printDocument(DocumentHandler documentHandler, InputSource templateSource, List modules) throws DocumentHandlerException, IOException {
        try {
            long startTime = System.currentTimeMillis();
            XMLReader xmlReader = this.createXmlReader();
            xmlReader.setContentHandler(documentHandler);
            XmlUtils.disableEntityResolver(xmlReader);
            if (modules != null) {
                int numModules = modules.size();
                for (int i = 0; i < numModules; ++i) {
                    byte[] moduleCode = (byte[])modules.get(i);
                    xmlReader.parse(new InputSource(new ByteArrayInputStream(moduleCode)));
                }
            }
            xmlReader.parse(templateSource);
            long endTime = System.currentTimeMillis();
            if (System.getProperty("ujac.profile") != null) {
                System.out.println("Needed " + (endTime - startTime) + " ms to process document.");
            }
            return documentHandler;
        }
        catch (SAXException ex) {
            Exception cause = ex.getException();
            if (cause != null) {
                if (cause instanceof DocumentHandlerException) {
                    throw (DocumentHandlerException)cause;
                }
                String causeMsg = cause.getMessage();
                if (cause instanceof ClassNotFoundException && causeMsg.indexOf(this.xmlReaderClass) >= 0) {
                    throw new DocumentHandlerException(documentHandler.locator(), "Unable to instantiate XML reader '" + this.xmlReaderClass + "', check your class path or specify a different implementation by calling the method setXmlReaderClass or by " + "defining the system property 'org.xml.sax.driver'.", cause);
                }
                throw new DocumentHandlerException(documentHandler.locator(), causeMsg, cause);
            }
            throw new DocumentHandlerException(documentHandler.locator(), ex.getMessage(), ex);
        }
    }

    protected DocumentHandler createDocumentHandler(OutputStream outputStream) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.addDefaultProperties();
        DocumentHandler documentHandler = null;
        if (this.formatHelper == null) {
            this.formatHelper = FormatHelper.createInstance();
        }
        documentHandler = this.templateInterpeter == null ? new DocumentHandler(outputStream, this.templateInterpeter, new TemplateContext(this.properties, this.formatHelper), this.tagFactory) : new DocumentHandler(outputStream, this.templateInterpeter, new TemplateContext(this.properties, this.formatHelper), this.tagFactory);
        documentHandler.setXmlReaderClass(this.xmlReaderClass);
        documentHandler.setDataAccessor(this.dataAccessor);
        documentHandler.setTagInterceptor(this.tagInterceptor);
        documentHandler.setContentFilter(this.contentFilter);
        documentHandler.setResourceLoader(this.resourceLoader);
        documentHandler.setMetaData(this.metaData);
        documentHandler.setTranslateEscapeSequences(this.translateEscapeSequences);
        documentHandler.setParseDynamicContent(this.parseDynamicContent);
        documentHandler.setEvaluateExpressions(this.evaluateExpressions);
        documentHandler.setCacheImages(this.cacheImages);
        documentHandler.setStrictlyCheckDocumentStructure(this.strictlyCheckDocumentStructure);
        documentHandler.setExpectedNumberOfPages(this.expectedNumberOfPages);
        return documentHandler;
    }

    public static Map loadProperties(String location) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            Properties props = new Properties();
            File propsFile = new File(location);
            if (!propsFile.exists()) {
                System.err.println("The property file '" + location + "' does not exist.");
            }
            FileInputStream propsInputStream = new FileInputStream(propsFile);
            props.load(propsInputStream);
            Iterator<Map.Entry<Object, Object>> propsIter = props.entrySet().iterator();
            while (propsIter.hasNext()) {
                Map.Entry<Object, Object> propsEntry = propsIter.next();
                String key = (String)propsEntry.getKey();
                int lastDotIdx = key.lastIndexOf(46);
                if (lastDotIdx > 0) {
                    String suffix = key.substring(lastDotIdx + 1);
                    try {
                        int i;
                        int numFields;
                        int idx = Integer.parseInt(suffix);
                        String sequenceName = key.substring(0, lastDotIdx);
                        Object sequence = properties.get(sequenceName);
                        if (sequence == null) {
                            String fieldsProp = props.getProperty(sequenceName + ".fields");
                            if (fieldsProp != null) {
                                DataTable sequenceTab = new DataTable();
                                List fieldNames = DocumentPrinter.parseRow(fieldsProp);
                                numFields = fieldNames.size();
                                for (i = 0; i < numFields; ++i) {
                                    StringTokenizer fieldDefTok = new StringTokenizer((String)fieldNames.get(i), ":");
                                    String fieldName = fieldDefTok.nextToken();
                                    String fieldType = fieldDefTok.nextToken();
                                    Column col = null;
                                    if (fieldType.equalsIgnoreCase("int")) {
                                        col = sequenceTab.addColumn(fieldName, 2);
                                    } else if (fieldType.equalsIgnoreCase("float")) {
                                        col = sequenceTab.addColumn(fieldName, 5);
                                    } else if (fieldType.equalsIgnoreCase("double")) {
                                        col = sequenceTab.addColumn(fieldName, 6);
                                    } else if (fieldType.equalsIgnoreCase("string")) {
                                        col = sequenceTab.addColumn(fieldName, 1);
                                    } else if (fieldType.equalsIgnoreCase("date")) {
                                        col = sequenceTab.addColumn(fieldName, 8);
                                        col.setFormat(new SimpleDateFormat("yyyy-MM-dd"));
                                    }
                                    if (!fieldDefTok.hasMoreTokens()) continue;
                                    String fieldTitle = fieldDefTok.nextToken();
                                    float fieldWidth = 0.0f;
                                    int fieldAlign = 0;
                                    if (fieldDefTok.hasMoreTokens()) {
                                        String strFieldWidth = fieldDefTok.nextToken();
                                        fieldWidth = Float.parseFloat(strFieldWidth);
                                    }
                                    if (fieldDefTok.hasMoreTokens()) {
                                        String strFieldAlign = fieldDefTok.nextToken();
                                        if (strFieldAlign.equalsIgnoreCase("left")) {
                                            fieldAlign = 0;
                                        } else if (strFieldAlign.equalsIgnoreCase("right")) {
                                            fieldAlign = 2;
                                        } else if (strFieldAlign.equalsIgnoreCase("center")) {
                                            fieldAlign = 1;
                                        }
                                    }
                                    col.setLayoutHints(new LayoutHints(fieldWidth, fieldTitle, fieldAlign));
                                }
                                sequence = sequenceTab;
                                properties.put(sequenceName, sequenceTab);
                            } else {
                                ArrayList sequenceList = new ArrayList();
                                sequence = sequenceList;
                                properties.put(sequenceName, sequenceList);
                            }
                        }
                        if (sequence instanceof DataTable) {
                            DataTable sequenceTab = (DataTable)sequence;
                            Row row = DocumentPrinter.ensureTableSize(sequenceTab, idx);
                            List fieldValues = DocumentPrinter.parseRow((String)propsEntry.getValue());
                            numFields = fieldValues.size();
                            for (i = 0; i < numFields; ++i) {
                                row.setString(i, (String)fieldValues.get(i));
                            }
                            continue;
                        }
                        List sequenceList = (List)sequence;
                        DocumentPrinter.ensureListSize(sequenceList, idx);
                        sequenceList.set(idx, propsEntry.getValue());
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                properties.put(key, propsEntry.getValue());
            }
        }
        catch (TableException ex) {
            throw new IOException("Table propblem encountered: " + ex.getMessage());
        }
        return properties;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    protected void addDefaultProperties() {
        Date currentDate = new Date();
        if (!this.properties.containsKey("today")) {
            this.properties.put("today", currentDate);
        }
        if (!this.properties.containsKey("now")) {
            this.properties.put("now", new Timestamp(currentDate.getTime()));
        }
    }

    protected List getModules() {
        return this.modules;
    }

    public static void main(String[] args) {
        File templateFile;
        HashMap options = new HashMap();
        int argStart = CommandLineHelper.parseOptions(args, options);
        int numArgs = 0;
        if (argStart >= 0) {
            numArgs = args.length - argStart;
        }
        if (numArgs < 2) {
            System.err.println("Usage: org.ujac.print.DocumentPrinter [options] <template> <outputfile> [<properties file>]");
            System.err.println("Available options: -language=<language code>");
            System.err.println("                   -country=<country code>");
            System.err.println("                   -resource-dir=<resource directory>");
            System.err.println("                   -module=<module location in resource directory>");
            System.err.println("                   -support-toc=<true/false>");
            System.exit(1);
        }
        if (!(templateFile = new File(args[argStart])).exists()) {
            System.err.println("The template file '" + templateFile + "' does not exist.");
        }
        try {
            String strSupportToc;
            FileInputStream templateInputStream = new FileInputStream(templateFile);
            File outputFile = new File(args[argStart + 1]);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            Map properties = null;
            if (numArgs >= 3) {
                properties = DocumentPrinter.loadProperties(args[argStart + 2]);
            }
            DocumentPrinter docPrinter = new DocumentPrinter(templateInputStream, properties);
            String resourceDir = (String)options.get("resource-dir");
            if (resourceDir == null) {
                resourceDir = ".";
            }
            docPrinter.setResourceLoader(new FileResourceLoader(resourceDir));
            String modulePath = (String)options.get("module");
            if (modulePath != null) {
                docPrinter.loadModule(modulePath);
            }
            String language = (String)options.get("language");
            String country = (String)options.get("country");
            if (language != null) {
                if (country != null) {
                    docPrinter.setFormatHelper(FormatHelper.createInstance(new Locale(language, country)));
                } else {
                    docPrinter.setFormatHelper(FormatHelper.createInstance(new Locale(language, "")));
                }
            }
            if ((strSupportToc = (String)options.get("support-toc")) != null) {
                docPrinter.printDocument(outputStream, new Boolean(strSupportToc));
            } else {
                docPrinter.printDocument(outputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentHandlerException e) {
            e.printStackTrace();
        }
    }

    private static void ensureListSize(List list, int index) {
        while (list.size() < index + 1) {
            list.add(null);
        }
    }

    private static Row ensureTableSize(DataTable table, int index) {
        while (table.getRowCount() < index + 1) {
            table.addRow();
        }
        try {
            return table.getRow(index);
        }
        catch (RowNotDefinedException ex) {
            return null;
        }
    }

    private static List parseRow(String row) {
        ArrayList<String> items = new ArrayList<String>();
        int rowLength = row.length();
        int lastItemStart = 0;
        block0: for (int i = 0; i < rowLength; ++i) {
            char c = row.charAt(i);
            if (c == '\'') {
                for (i = lastItemStart = i + 1; i < rowLength; ++i) {
                    c = row.charAt(i);
                    if (c != '\'') continue;
                    items.add(row.substring(lastItemStart, i));
                    lastItemStart = ++i + 1;
                    continue block0;
                }
                continue;
            }
            if (c != ',') continue;
            items.add(row.substring(lastItemStart, i));
            lastItemStart = i + 1;
        }
        if (lastItemStart < rowLength) {
            items.add(row.substring(lastItemStart, rowLength));
        }
        return items;
    }

    public DocumentTagFactory getTagFactory() {
        return this.tagFactory;
    }

    public void setTagFactory(DocumentTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public DocumentMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(DocumentMetaData metaData) {
        this.metaData = metaData;
    }
}

