/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ujac.print.AbstractTagTest;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagInterceptor;
import org.ujac.util.CollectionUtils;

public class TestTagInterceptor
implements DocumentTagInterceptor {
    private int level = 0;
    private Map testMap = new HashMap();

    public void addTest(String tagId, AbstractTagTest test) {
        ArrayList<AbstractTagTest> tagTests = (ArrayList<AbstractTagTest>)this.testMap.get(tagId);
        if (tagTests == null) {
            tagTests = new ArrayList<AbstractTagTest>();
            this.testMap.put(tagId, tagTests);
        }
        tagTests.add(test);
    }

    public boolean isAllTestsPassed() {
        Collection tagTestSet = this.testMap.values();
        Iterator iterTagTests = tagTestSet.iterator();
        while (iterTagTests.hasNext()) {
            List testCases = (List)iterTagTests.next();
            int numTests = CollectionUtils.getSize(testCases);
            for (int i = 0; i < numTests; ++i) {
                AbstractTagTest testCase = (AbstractTagTest)testCases.get(i);
                if (testCase.isTestPassed()) continue;
                return false;
            }
        }
        return true;
    }

    public void clearTests() {
        this.testMap.clear();
    }

    public boolean beforeOpen(BaseDocumentTag tag) throws DocumentHandlerException {
        ++this.level;
        return true;
    }

    public void afterOpen(BaseDocumentTag tag) throws DocumentHandlerException {
    }

    public boolean beforeClose(BaseDocumentTag tag) throws DocumentHandlerException {
        this.doTests(tag, 1);
        return true;
    }

    public void afterClose(BaseDocumentTag tag) throws DocumentHandlerException {
        this.doTests(tag, 2);
        --this.level;
    }

    private void doTests(BaseDocumentTag tag, int mode) throws DocumentHandlerException {
        if (!tag.isValid()) {
            return;
        }
        String tagId = tag.getStringAttribute("id", "", true, null);
        List tagTests = (List)this.testMap.get(tagId);
        int numTagTests = CollectionUtils.getSize(tagTests);
        for (int i = 0; i < numTagTests; ++i) {
            AbstractTagTest tagTest = (AbstractTagTest)tagTests.get(i);
            if (tagTest.getTestMode() != mode) continue;
            tagTest.setup(tag);
            tagTest.doIt();
        }
    }
}

