/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.DefineTableTag;

public class AddColumnTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "add-column";
    private static final AttributeDefinition COLUMN_NAME = CommonAttributes.COLUMN_NAME.cloneAttrDef("The name of the column to add.");
    private DefineTableTag defineTable = null;
    private String name = null;
    private String type = null;

    public AddColumnTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a column for the surrounding table.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(COLUMN_NAME).addDefinition(CommonAttributes.COLUMN_TYPE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.defineTable = (DefineTableTag)this.documentHandler.latestOfType(DefineTableTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.COLUMN_NAME, false, null);
        this.type = this.getStringAttribute(CommonAttributes.COLUMN_TYPE, false, null);
        this.defineTable.defineColumn(this.name, this.type);
    }
}

