/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CustomTagTag;

public class AttributeTag
extends BaseDocumentTag {
    private static final AttributeDefinition ATTR_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the attribute to set.");
    private static final AttributeDefinition ATTR_VALUE = new AttributeDefinition("value", 4, false, "The attribute value.");
    public static final String TAG_NAME = "attribute";
    private CustomTagTag customTag = null;
    private String name = null;
    private String value = null;

    public AttributeTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Specifies an attribute for the enclosing custom tag definition.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(ATTR_NAME).addDefinition(ATTR_VALUE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.customTag = (CustomTagTag)this.documentHandler.latestOfType(CustomTagTag.class);
        this.name = this.getStringAttribute(CommonAttributes.NAME, false, null);
        if ("tagName".equals(this.name)) {
            throw new TagAttributeException(this.locator(), "The attribute 'tagName' is no legal custom attribute.");
        }
        this.value = this.getStringAttribute(ATTR_VALUE, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.customTag.setAttribute(this.name, this.value);
    }
}

