/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BarcodeCodabar;
import com.lowagie.text.pdf.BarcodeEAN;
import com.lowagie.text.pdf.BarcodeInter25;
import com.lowagie.text.pdf.BarcodePostnet;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.exi.ExpressionException;

public class BarcodeTag
extends BaseElementTag {
    private static final AttributeDefinition BARCODE_TYPE = new AttributeDefinition("type", new String[]{"CODABAR", "CODE39", "CODE39EXT", "INTER25", "CODE128", "CODE128UCC", "CODE128RAW", "EAN13", "EAN8", "PLANET", "POSTNET", "SUPP2", "SUPP5", "UPCA", "UPCE"}, true, "The barcode type.");
    private static final AttributeDefinition BARCODE_BAR_WIDTH = new AttributeDefinition("bar-width", 14, false, "The width of one single bar.");
    private static final AttributeDefinition BARCODE_BAR_HEIGHT = new AttributeDefinition("bar-height", 14, false, "The height of a bar.");
    private static final AttributeDefinition BARCODE_BAR_COLOR = new AttributeDefinition("bar-color", 5, false, "The bar color.");
    private static final AttributeDefinition BARCODE_TEXT_COLOR = new AttributeDefinition("text-color", 5, false, "The color of the text below the bar.");
    private static final AttributeDefinition BARCODE_ROTATE = new AttributeDefinition("rotate", 3, false, "The rotation flag.");
    private static final AttributeDefinition BARCODE_START_STOP_TEXT = new AttributeDefinition("start-stop-text", 3, false, "The start-stop text flag.");
    private static final AttributeDefinition BARCODE_GENERATE_CHECKSUM = new AttributeDefinition("generate-checksum", 3, false, "The flag deciding, whether to generate a checksum or not.");
    private static final AttributeDefinition BARCODE_BASELINE = new AttributeDefinition("baseline", 2, false, "If positive the text distance above the bars, if negative, the text distance below the bars.");
    private static final AttributeDefinition BARCODE_FONT = CommonAttributes.FONT.cloneAttrDef("The name of the font to use for the barcode label.");
    private static final AttributeDefinition BARCODE_FONT_STYLE = CommonStyleAttributes.FONT.cloneAttrDef("The name of the font to use for the barcode label.");
    public static final String TAG_NAME = "barcode";
    public static final int CODE39 = 30;
    public static final int CODE39EXT = 31;
    public static final int INTER25 = 32;
    private static Map barcodeTypes = null;
    private PhraseHolder phraseHolder = null;
    private String typeAttr = null;
    private float barWidth = 0.0f;
    private float barHeight = 0.0f;
    private Color barColor = null;
    private Color textColor = null;
    private boolean rotate = false;
    private boolean startStopTextAttr = false;
    private String generateChecksumAttr = null;
    private String baselineAttr = null;

    public BarcodeTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Prints a barcode.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(BARCODE_TYPE).addDefinition(BARCODE_FONT).addDefinition(BARCODE_BAR_WIDTH).addDefinition(BARCODE_BAR_HEIGHT).addDefinition(BARCODE_BAR_COLOR).addDefinition(BARCODE_TEXT_COLOR).addDefinition(BARCODE_ROTATE).addDefinition(BARCODE_START_STOP_TEXT).addDefinition(BARCODE_GENERATE_CHECKSUM).addDefinition(BARCODE_BASELINE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(BARCODE_FONT_STYLE).addDefinition(BARCODE_BAR_WIDTH).addDefinition(BARCODE_BAR_HEIGHT).addDefinition(BARCODE_BAR_COLOR).addDefinition(BARCODE_TEXT_COLOR);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.typeAttr = this.getStringAttribute(BARCODE_TYPE, true, null);
        this.barWidth = this.getDimensionAttribute(BARCODE_BAR_WIDTH, true, BARCODE_BAR_WIDTH);
        this.barHeight = this.getDimensionAttribute(BARCODE_BAR_HEIGHT, true, BARCODE_BAR_HEIGHT);
        this.barColor = this.getColorAttribute(BARCODE_BAR_COLOR, true, BARCODE_BAR_COLOR);
        this.textColor = this.getColorAttribute(BARCODE_TEXT_COLOR, true, BARCODE_TEXT_COLOR);
        this.rotate = this.getBooleanAttribute(BARCODE_ROTATE, true, null);
        this.startStopTextAttr = this.getBooleanAttribute(BARCODE_START_STOP_TEXT, false, true, null);
        this.generateChecksumAttr = this.getStringAttribute(BARCODE_GENERATE_CHECKSUM, true, null);
        this.baselineAttr = this.getStringAttribute(BARCODE_BASELINE, true, null);
        String code = null;
        try {
            code = this.documentHandler.evalString(this.getTrimmedContent());
        }
        catch (ExpressionException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        PdfContentByte cb = ((PdfWriter)this.documentHandler.getDocumentWriter()).getDirectContent();
        Barcode39 barcode = null;
        String typeString = null;
        try {
            typeString = this.documentHandler.evalString(this.typeAttr).toUpperCase();
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        Integer type = (Integer)barcodeTypes.get(typeString);
        if (type == null) {
            throw new TagAttributeException(this.locator(), "Unsupported barcode type '" + typeString + "'.");
        }
        switch (type) {
            case 30: 
            case 31: {
                barcode = new Barcode39();
                if (type != 31) break;
                barcode.setExtended(true);
                break;
            }
            case 32: {
                barcode = new BarcodeInter25();
                break;
            }
            case 12: {
                barcode = new BarcodeCodabar();
                break;
            }
            case 1: {
                if (code.length() != 13) {
                    throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: The length must be excactly 13 characters!");
                }
                barcode = new BarcodeEAN();
                break;
            }
            case 2: {
                if (code.length() != 8) {
                    throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: The length must be excactly 8 characters!");
                }
                barcode = new BarcodeEAN();
                break;
            }
            case 3: {
                if (code.length() != 12) {
                    throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: The length must be excactly 12 characters!");
                }
                barcode = new BarcodeEAN();
                break;
            }
            case 4: {
                if (code.length() != 8) {
                    throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: The length must be excactly 8 characters!");
                }
                barcode = new BarcodeEAN();
                break;
            }
            case 5: 
            case 6: {
                barcode = new BarcodeEAN();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                barcode = new Barcode128();
                break;
            }
            case 7: 
            case 8: {
                barcode = new BarcodePostnet();
                break;
            }
            default: {
                throw new TagAttributeException(this.locator(), "Unsupported barcode type '" + this.typeAttr + "'");
            }
        }
        barcode.setCodeType(type.intValue());
        try {
            if (this.baselineAttr != null) {
                float baseLine = this.documentHandler.evalFloat(this.baselineAttr);
                barcode.setBaseline(baseLine);
            }
            if (this.generateChecksumAttr != null && this.documentHandler.evalBoolean(this.generateChecksumAttr)) {
                barcode.setGenerateChecksum(true);
            }
            if (this.isAttributeDefined(BARCODE_BAR_WIDTH)) {
                barcode.setX(this.barWidth);
            }
            if (this.isAttributeDefined(BARCODE_BAR_HEIGHT)) {
                barcode.setBarHeight(this.barHeight);
            }
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        barcode.setFont(this.getFont().getFont().getBaseFont());
        barcode.setCodeType(type.intValue());
        barcode.setStartStopText(this.startStopTextAttr);
        barcode.setCode(code);
        ElementContainer elementContainer = this.getElementContainer();
        try {
            Image barcodeImage = barcode.createImageWithBarcode(cb, this.barColor, this.textColor);
            if (this.rotate) {
                barcodeImage.setRotation(1.5707964f);
            }
            if (this.phraseHolder != null) {
                this.phraseHolder.addChunk(this, new Chunk(barcodeImage, 0.0f, 0.0f));
            } else {
                elementContainer.addElement(this, (Element)barcodeImage);
            }
        }
        catch (DocumentHandlerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TagAttributeException(this.locator(), "Creation of barcode '" + this.typeAttr + "' failed: " + ex.getMessage(), ex);
        }
    }

    static {
        barcodeTypes = new HashMap();
        barcodeTypes.put("CODABAR", new Integer(12));
        barcodeTypes.put("CODE39", new Integer(30));
        barcodeTypes.put("CODE39EXT", new Integer(31));
        barcodeTypes.put("INTER25", new Integer(32));
        barcodeTypes.put("CODE128", new Integer(9));
        barcodeTypes.put("CODE128UCC", new Integer(10));
        barcodeTypes.put("CODE128RAW", new Integer(11));
        barcodeTypes.put("EAN13", new Integer(1));
        barcodeTypes.put("EAN8", new Integer(2));
        barcodeTypes.put("PLANET", new Integer(8));
        barcodeTypes.put("POSTNET", new Integer(7));
        barcodeTypes.put("SUPP2", new Integer(5));
        barcodeTypes.put("SUPP5", new Integer(6));
        barcodeTypes.put("UPCA", new Integer(3));
        barcodeTypes.put("UPCE", new Integer(4));
    }
}

