/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentEvent;
import org.ujac.print.DocumentEventRecorder;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagInterceptor;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.SequenceIndex;
import org.ujac.util.table.Table;
import org.ujac.util.template.TemplateContext;

public abstract class BaseLoopTag
extends BaseElementTag
implements DocumentEventRecorder {
    private static final Class[] iteratorAttributes = new Class[0];
    private static final Object[] iteratorParameters = new Object[0];
    protected boolean insertItems = false;
    private boolean firstLoop = false;
    private String loopVariable = null;
    private String loopIdxVariable = null;
    private String sequenceExpression = null;
    protected Object sequenceHolder = null;
    protected Iterator sequenceIterator = null;
    private List documentEvents = new ArrayList();
    private DocumentEventRecorder parentEventRecorder = null;
    protected SequenceIndex iterationIdx = null;
    private Object currentValue = null;

    public BaseLoopTag(String name) {
        super(name);
    }

    public Object getSequenceHolder() {
        return this.sequenceHolder;
    }

    protected void setSequenceHolder(Object sequenceHolder) {
        this.sequenceHolder = sequenceHolder;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(Object currentValue) {
        this.currentValue = currentValue;
    }

    public String getLoopVariable() {
        return this.loopVariable;
    }

    protected void setLoopVariable(String loopVariable) {
        this.loopVariable = loopVariable;
        this.loopIdxVariable = loopVariable + "Idx";
    }

    public String getLoopIdxVariable() {
        return this.loopIdxVariable;
    }

    public boolean hasNext() {
        if (this.sequenceIterator == null) {
            return false;
        }
        return this.sequenceIterator.hasNext();
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.setLoopVariable(this.getStringAttribute("loop-variable", null, false, null));
        if (this.isAttributeDefined("sequence")) {
            this.sequenceExpression = this.getStringAttribute("sequence", null, false, null);
        }
        this.parentEventRecorder = this.documentHandler.topEventRecorder();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.documentHandler.pushEventRecorder(this);
        if (!this.isValid()) {
            return;
        }
        if (this.sequenceExpression != null) {
            try {
                this.sequenceHolder = this.documentHandler.evalObject(this.sequenceExpression);
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
        }
        if (this.sequenceHolder == null) {
            this.insertItems = false;
            return;
        }
        if (this.sequenceHolder instanceof Collection) {
            this.sequenceIterator = ((Collection)this.sequenceHolder).iterator();
        } else if (this.sequenceHolder instanceof Iterator) {
            this.sequenceIterator = (Iterator)this.sequenceHolder;
        } else if (this.sequenceHolder instanceof Map) {
            this.sequenceIterator = ((Map)this.sequenceHolder).keySet().iterator();
        } else if (this.sequenceHolder instanceof Table) {
            this.sequenceIterator = ((Table)this.sequenceHolder).iterator();
        } else if (this.sequenceHolder instanceof Object[]) {
            List<Object> sequenceList = Arrays.asList((Object[])this.sequenceHolder);
            this.sequenceIterator = sequenceList.iterator();
        } else if (this.sequenceHolder instanceof String) {
            StringTokenizer strTkn = new StringTokenizer(this.sequenceHolder.toString(), "-");
            if (strTkn.countTokens() == 2) {
                String strFrom = strTkn.nextToken();
                String strTo = strTkn.nextToken();
                int from = -1;
                try {
                    from = Integer.parseInt(strFrom);
                }
                catch (NumberFormatException ex) {
                    throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
                }
                int to = -1;
                try {
                    to = Integer.parseInt(strTo);
                }
                catch (NumberFormatException ex) {
                    throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
                }
                ArrayList<Integer> sequence = new ArrayList<Integer>();
                for (int i = from; i <= to; ++i) {
                    sequence.add(new Integer(i));
                }
                this.sequenceIterator = sequence.iterator();
            } else {
                strTkn = new StringTokenizer(this.sequenceHolder.toString(), ",");
                if (strTkn.countTokens() < 2) {
                    throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.");
                }
                ArrayList<String> sequence = new ArrayList<String>();
                while (strTkn.hasMoreTokens()) {
                    sequence.add(strTkn.nextToken());
                }
                this.sequenceIterator = sequence.iterator();
            }
        } else {
            try {
                Method iteratorMethod = this.sequenceHolder.getClass().getMethod("iterator", iteratorAttributes);
                this.sequenceIterator = (Iterator)iteratorMethod.invoke(this.sequenceHolder, iteratorParameters);
            }
            catch (SecurityException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
            catch (ClassCastException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
            catch (IllegalAccessException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
            catch (InvocationTargetException ex) {
                throw new TagAttributeException(this.locator(), "The attribute 'sequence' at tag '" + this.getName() + "' doesn't evaluate to a valid sequence.", ex);
            }
        }
        this.iterationIdx = null;
        this.insertItems = false;
    }

    public void closeItem() throws DocumentHandlerException {
        this.documentHandler.popEventRecorder();
        if (!this.isValid()) {
            return;
        }
        boolean insertItemsOld = this.insertItems;
        this.insertItems = true;
        this.firstLoop = true;
        this.preLoopChildItems();
        if (this.sequenceIterator != null && this.sequenceIterator.hasNext()) {
            TemplateContext ctx = this.documentHandler.getTemplateContext();
            this.iterationIdx = new SequenceIndex(0);
            ctx.setProperty(this.loopIdxVariable, this.iterationIdx);
            while (this.sequenceIterator.hasNext()) {
                Object nextValue = this.sequenceIterator.next();
                ctx.setProperty(this.loopVariable, nextValue);
                this.currentValue = nextValue;
                if (!this.preRepeatChildItems()) continue;
                this.repeatChildItems();
                this.postRepeatChildItems();
                this.iterationIdx.increment();
            }
        }
        this.postLoopChildItems();
        this.insertItems = insertItemsOld;
    }

    protected void preLoopChildItems() throws DocumentHandlerException {
    }

    protected void postLoopChildItems() throws DocumentHandlerException {
    }

    public boolean isTrue() {
        return this.insertItems;
    }

    public boolean isFirstLoop() {
        return this.firstLoop;
    }

    protected boolean preRepeatChildItems() throws DocumentHandlerException {
        return true;
    }

    protected void postRepeatChildItems() throws DocumentHandlerException {
    }

    protected void repeatChildItems() throws DocumentHandlerException {
        this.setItemClosed(false);
        DocumentTagInterceptor tagInterceptor = this.documentHandler.getTagInterceptor();
        int numEvents = this.documentEvents.size();
        block5: for (int i = 0; i < numEvents; ++i) {
            DocumentEvent event = (DocumentEvent)this.documentEvents.get(i);
            BaseDocumentTag item = event.getItem();
            if (i == numEvents - 1) {
                this.setItemClosed(true);
            }
            switch (event.getType()) {
                case 1: {
                    BaseDocumentTag topItem = item.getParentItem();
                    if (topItem != null) {
                        topItem.flushContent();
                    }
                    this.documentHandler.pushItem(item);
                    if (tagInterceptor != null && !tagInterceptor.beforeOpen(item)) continue block5;
                    item.openItem();
                    if (tagInterceptor == null) continue block5;
                    tagInterceptor.afterOpen(item);
                    continue block5;
                }
                case 2: {
                    String content = event.getContent();
                    if (content.length() <= 0) continue block5;
                    item.setItemOpened(false);
                    item.addContent(content);
                    if (i != numEvents - 1) continue block5;
                    item.flushContent();
                    continue block5;
                }
                case 3: {
                    item.setItemClosed(true);
                    item.flushContent();
                    if (tagInterceptor == null || tagInterceptor.beforeClose(item)) {
                        item.closeItem();
                        if (tagInterceptor != null) {
                            tagInterceptor.afterClose(item);
                        }
                    }
                    this.documentHandler.popItem();
                    continue block5;
                }
                default: {
                    throw new DocumentHandlerException(this.locator(), "Encountered illegal event type '" + event.getType() + "!");
                }
            }
        }
        this.firstLoop = false;
    }

    public void recordEvent(DocumentEvent event) {
        if (event.getItem() != this) {
            this.documentEvents.add(event);
        } else if (event.getType() == 2) {
            this.documentEvents.add(event);
            this.resetContent();
        } else if (this.parentEventRecorder != null) {
            this.parentEventRecorder.recordEvent(event);
        }
    }
}

