/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.ConditionTag;
import org.ujac.print.tag.SwitchTag;

public class CaseTag
extends ConditionTag {
    private static final AttributeDefinition VALUE = new AttributeDefinition("value", 4, false, "The attribute value.");
    public static final String TAG_NAME = "case";
    private SwitchTag switchItem = null;
    private String value = null;

    public CaseTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Conditional item, which evalutes its content in case the given value matches the value of the surrounding 'switch' tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(VALUE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        BaseDocumentTag parent = this.getParentItem();
        if (!(parent instanceof SwitchTag)) {
            throw new DocumentHandlerException(this.locator(), "The parent of item 'case' must be an 'switch'!");
        }
        this.switchItem = (SwitchTag)parent;
        this.value = this.getStringAttribute(VALUE, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            this.result = false;
            return;
        }
        super.openItem();
        this.result = this.switchItem.equalsValue(this.value);
    }
}

