/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.tag.TagAttributes;

public interface CommonAttributes
extends TagAttributes {
    public static final AttributeDefinition ID = new AttributeDefinition("id", 12, false, "The unique identifier of the item.");
    public static final AttributeDefinition NAME = new AttributeDefinition("name", 12, true, "The name of the item.");
    public static final AttributeDefinition STYLE = new AttributeDefinition("style", 4, false, "The attribute style definition to use (eg. 'border-width:10; border-color: red; padding: 10;...').");
    public static final AttributeDefinition CLASS = new AttributeDefinition("class", 12, false, "The name of the style class to use (see style-def tag).");
    public static final AttributeDefinition RENDERED = new AttributeDefinition("rendered", 3, false, "Rules, whether or not the given element is actually rendered.");
    public static final AttributeDefinition FONT = new AttributeDefinition("font", 12, false, "The name of the font definition to use.");
    public static final AttributeDefinition BACKGROUND_COLOR = new AttributeDefinition("bgcolor", 5, false, "Defines the background color.");
    public static final AttributeDefinition BORDER_STYLE = new AttributeDefinition("border-style", 6, false, "Defines the border type.");
    public static final AttributeDefinition BORDER_WIDTH = new AttributeDefinition("border-width", 14, false, "Defines the border width.");
    public static final AttributeDefinition BORDER_COLOR = new AttributeDefinition("border-color", 5, false, "Defines the border color.");
    public static final AttributeDefinition HORIZONTAL_ALIGNMENT = new AttributeDefinition("halign", 7, false, "Defines the horizontal alignment (left|right|center).").addAlias("align");
    public static final AttributeDefinition VERTICAL_ALIGNMENT = new AttributeDefinition("valign", 8, false, "Defines the vertical alignment (top|bottom|middle).");
    public static final AttributeDefinition CELL_HORIZONTAL_ALIGNMENT = new AttributeDefinition("cell-halign", 7, false, "Defines the horizontal alignment for the nested cells.").addAlias("cell-align");
    public static final AttributeDefinition CELL_VERTICAL_ALIGNMENT = new AttributeDefinition("cell-valign", 8, false, "Defines the vertical alignment for the nested cells.");
    public static final AttributeDefinition TEXT_ALIGNMENT = new AttributeDefinition("text-align", 7, false, "Defines the text alignment.");
    public static final AttributeDefinition PADDING = new AttributeDefinition("padding", 14, false, "Defines the padding for all border edges.");
    public static final AttributeDefinition PADDING_LEFT = new AttributeDefinition("padding-left", 14, false, "Defines the left padding.");
    public static final AttributeDefinition PADDING_RIGHT = new AttributeDefinition("padding-right", 14, false, "Defines the right padding.");
    public static final AttributeDefinition PADDING_TOP = new AttributeDefinition("padding-top", 14, false, "Defines the top padding.");
    public static final AttributeDefinition PADDING_BOTTOM = new AttributeDefinition("padding-bottom", 14, false, "Defines the bottom padding.");
    public static final AttributeDefinition LINE_SPACING = new AttributeDefinition("line-spacing", 14, false, "The line spacing factor for contents (is 1.2).");
    public static final AttributeDefinition LEADING = new AttributeDefinition("leading", 14, false, "The fixed vertical leading distance.");
    public static final AttributeDefinition SPACING_BEFORE = new AttributeDefinition("spacing-before", 14, false, "The vertical spacing before the items.");
    public static final AttributeDefinition SPACING_AFTER = new AttributeDefinition("spacing-after", 14, false, "The vertical spacing after the items.");
    public static final AttributeDefinition TRIM_BODY = new AttributeDefinition("trim-body", 3, false, "Tells whether to trim the body or not, default behaviour is not to trim the contents of the tag's body.");
    public static final AttributeDefinition KEEP_TOGETHER = new AttributeDefinition("keep-together", 3, false, "Tells whether or not the items's contents should be kept together on one page.");
    public static final AttributeDefinition PAGE_SIZE = new AttributeDefinition("size", 9, false, "The page size (LETTER|NOTE|LEGAL|A0|A1|A2|A3|A4|A5|A6|A7|A8|A9|A10|B0|B1|B2|B3|B4|B5).");
    public static final AttributeDefinition PAGE_WIDTH = new AttributeDefinition("width", 14, false, "The page-width can be used alternatively together with page-height to define a custom document size.");
    public static final AttributeDefinition PAGE_HEIGHT = new AttributeDefinition("height", 14, false, "The page-height can be used alternatively together with page-width to define a custom document size.");
    public static final AttributeDefinition PAGE_ROTATE = new AttributeDefinition("rotate", 3, false, "The rotation flag, if true the page gets rotated 90 degrees clockwise.");
    public static final AttributeDefinition COLOR = new AttributeDefinition("color", 5, false, "The foreground color.");
    public static final AttributeDefinition COLSPAN = new AttributeDefinition("colspan", 1, false, "The column span of the cell.");
    public static final AttributeDefinition FILL_ROW = new AttributeDefinition("fill-row", 3, false, "Tells whether or not to fill up the current table row.");
    public static final AttributeDefinition NO_WRAP = new AttributeDefinition("no-wrap", 3, false, "The no wrap flag.");
    public static final AttributeDefinition ROTATE = new AttributeDefinition("rotate", 2, false, "The rotation angle.");
    public static final AttributeDefinition ROTATE_FLAG = new AttributeDefinition("rotate", 3, false, "The rotation flag.");
    public static final AttributeDefinition INDENTATION = new AttributeDefinition("indentation", 14, false, "The indentation of the content.");
    public static final AttributeDefinition MARGIN_LEFT = new AttributeDefinition("margin-left", 14, false, "The left margin.");
    public static final AttributeDefinition MARGIN_RIGHT = new AttributeDefinition("margin-right", 14, false, "The right margin.");
    public static final AttributeDefinition MARGIN_TOP = new AttributeDefinition("margin-top", 14, false, "The top margin.");
    public static final AttributeDefinition MARGIN_BOTTOM = new AttributeDefinition("margin-bottom", 14, false, "The bottom margin.");
    public static final AttributeDefinition FONT_NAME = new AttributeDefinition("name", 12, true, "The name of the font definition.");
    public static final AttributeDefinition FONT_COLOR = new AttributeDefinition("color", 5, false, "The font color.");
    public static final AttributeDefinition FONT_FAMILY = new AttributeDefinition("family", 10, false, "The font family.").addAlias("font-family");
    public static final AttributeDefinition FONT_ENCODING = new AttributeDefinition("encoding", new String[]{"Cp1250", "Cp1252", "Cp1257", "UniGB-UCS2-H", "UniGB-UCS2-V", "UniCNS-UCS2-H", "UniCNS-UCS2-V", "UniJIS-UCS2-H", "UniJIS-UCS2-V", "UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-V", "UniKS-UCS2-H", "UniKS-UCS2-V"}, false, "The font encoding (default is Cp1252). For encodings  different from Cp1250, Cp1252 and Cp1257 make sure that the asian extensions (iTextAsian.jar) are available in your class path.").addAlias("font-encoding");
    public static final AttributeDefinition FONT_SIZE = new AttributeDefinition("size", 14, false, "The font size.").addAlias("font-size");
    public static final AttributeDefinition FONT_STYLE = new AttributeDefinition("font-style", 11, false, "For undecorated fonts use 'normal'. Otherwise define one of these, or a combination of them: bold|italic|oblique|underline|line-through.");
    public static final AttributeDefinition TEXT_RISE = new AttributeDefinition("text-rise", 14, false, "The text displacement relative to the baseline. Positive values rise the text, negative values lower the text.");
    public static final AttributeDefinition CELL_HEIGHT = new AttributeDefinition("height", 14, false, "Defines a fixed height for the nested cells.");
    public static final AttributeDefinition TABLE_WIDTH = new AttributeDefinition("width", 2, false, "The table widths in percent (default is 100.0).");
    public static final AttributeDefinition TABLE_WIDTHS = new AttributeDefinition("widths", 4, false, "The table widths, a comma separated list of percentual column widths.");
    public static final AttributeDefinition TABLE_COLUMNS = new AttributeDefinition("columns", 1, false, "The number of table columns.");
    public static final AttributeDefinition TABLE_SPLIT_ROWS = new AttributeDefinition("split-rows", 3, false, "Tells whether to split table rows accross pages or not.");
    public static final AttributeDefinition TABLE_SPLIT_LATE = new AttributeDefinition("split-late", 3, false, "Tells whether to split rows late or not. If true the row will only split if it's the first one in an empty page.");
    public static final AttributeDefinition GROUP_NAME = new AttributeDefinition("group-name", 12, false, "The name of the supported group.");
    public static final AttributeDefinition TABLE_HALIGN = HORIZONTAL_ALIGNMENT.cloneAttrDef("The horizontal alignment of the table.");
    public static final AttributeDefinition IMAGE_X = new AttributeDefinition("x", 14, false, "The horizontal position, needed for absolute positioning. In case you've specified a negative value, the image will be placed relative to the right page border");
    public static final AttributeDefinition IMAGE_Y = new AttributeDefinition("y", 14, false, "The vertical position, needed for absolute positioning. In case you've specified a negative value, the image will be placed relative to the top page border");
    public static final AttributeDefinition IMAGE_WIDTH = new AttributeDefinition("width", 14, false, "The image width, if no height is given, the image height is scaled with the same factor to keep the image proportions.");
    public static final AttributeDefinition IMAGE_HEIGHT = new AttributeDefinition("height", 14, false, "The image height, if no width is given, the image width is scaled with the same factor to keep the image proportions.");
    public static final AttributeDefinition SCALE_TO_FIT = new AttributeDefinition("scale-to-fit", 3, false, "Tells whether to scale the image to fit the given width and height by keeping the original aspect ratio.");
    public static final AttributeDefinition IMAGE_ROTATE = new AttributeDefinition("rotate", 2, false, "The image rotation angle.");
    public static final AttributeDefinition IMAGE_SOURCE = new AttributeDefinition("source", 4, true, "The image source can be the path to the image to load via ResourceLoader or an expression that resolves to an java.awt.Image or an com.lowagie.text.Image instance.");
    public static final AttributeDefinition IMAGE_PAGE = new AttributeDefinition("page", 1, false, "The page from the source to use as image, this is currently only supported for PDF documents.");
    public static final AttributeDefinition IMAGE_HORIZONTAL_ALIGNMENT = HORIZONTAL_ALIGNMENT.cloneAttrDef("The image's horizontal alignment (left|right|center).");
    public static final AttributeDefinition IMAGE_VERTICAL_ALIGNMENT = VERTICAL_ALIGNMENT.cloneAttrDef("The image's vertical alignment (top|bottom|middle).");
    public static final AttributeDefinition IMAGE_TEXTWRAP = new AttributeDefinition("textwrap", 3, false, "The text wrap flag.");
    public static final AttributeDefinition IMAGE_UNDERLYING = new AttributeDefinition("underlying", 3, false, "The underlying flag.");
    public static final AttributeDefinition IMAGE_DRAW_FOREGROUND = new AttributeDefinition("draw-foreground", 3, false, "Tells whether to draw the image in the foreground or in the background.");
    public static final AttributeDefinition BOX_X = new AttributeDefinition("x", 14, true, "The horizontal position of the box. In case you've specified a negative value, the box will be placed relative to the right page border");
    public static final AttributeDefinition BOX_Y = new AttributeDefinition("y", 14, true, "The vertical position of the box. In case you've specified a negative value, the box will be placed relative to the top page border");
    public static final AttributeDefinition BOX_WIDTH = new AttributeDefinition("width", 14, true, "The width of the box.");
    public static final AttributeDefinition BOX_HEIGHT = new AttributeDefinition("height", 14, true, "The height of the box.");
    public static final AttributeDefinition ALTER_TABLE = new AttributeDefinition("table", 12, true, "The name of the table to modify.");
    public static final AttributeDefinition ALTER_DISTINCT = new AttributeDefinition("distinct", 3, false, "Tells whether or not to allow duplicates.");
    public static final AttributeDefinition TABLE_NAME = new AttributeDefinition("name", 12, true, "The name of the table to define.");
    public static final AttributeDefinition COLUMN_NAME = new AttributeDefinition("name", 12, false, "The column name.");
    public static final AttributeDefinition COLUMN_INDEX = new AttributeDefinition("index", 1, false, "The column name.");
    public static final AttributeDefinition COLUMN_WIDTH = new AttributeDefinition("width", 2, false, "The column width.");
    public static final AttributeDefinition COLUMN_TITLE = new AttributeDefinition("title", 4, false, "The column title.");
    public static final AttributeDefinition COLUMN_TYPE = new AttributeDefinition("type", new String[]{"int", "float", "long", "double", "String", "Date", "Time", "Timestamp", "Object"}, true, "The data type to use for this column.");
    public static final AttributeDefinition COLUMN_REFERENCE = new AttributeDefinition("reference", 4, true, "The reference column at which to insert the new column.");
    public static final AttributeDefinition COLUMN_DIRECTION = new AttributeDefinition("direction", 12, false, "The insert direction: 'before' | 'after'.");
    public static final AttributeDefinition CONDITION = new AttributeDefinition("cond", 4, true, "The condition to test, this may be a boolean constant, but will mostly be an expression.");
    public static final AttributeDefinition LOOP_VARIABLE = new AttributeDefinition("loop-variable", 12, true, "The loop variable, holds the current value from the specified sequence. Together with the loop variable there will be a property available called variable + 'Idx', which holds the index of the current element from the sequence.");
    public static final AttributeDefinition SEQUENCE = new AttributeDefinition("sequence", 4, true, "An expression evaluating to a valid sequence. Valid sequences are objects of each type that implement a public method called 'iterator()' which serves an instance that implements the interface java.util.Iterator.");
    public static final AttributeDefinition CHAPTER_NUMBER = new AttributeDefinition("number", 1, false, "The number of the chapter.");
    public static final AttributeDefinition CHAPTER_TITLE = new AttributeDefinition("title", 4, false, "The title of the chapter.");
    public static final AttributeDefinition CHAPTER_TITLE_FONT = new AttributeDefinition("title-font", 12, false, "The font to use for the chapter title output.");
    public static final AttributeDefinition SECTION_NUMBER_DEPTH = new AttributeDefinition("number-depth", 1, false, "The numbering depth.");
    public static final AttributeDefinition SECTION_TITLE = new AttributeDefinition("title", 4, false, "The title of the section.");
    public static final AttributeDefinition SECTION_TITLE_FONT = new AttributeDefinition("title-font", 12, false, "The font to use for the section title output.");
    public static final AttributeDefinition TOC_RELEVANCE = new AttributeDefinition("toc-relevance", new String[]{"toc", "index", "all"}, false, "Defined the relevance of the item for the table of contents or index of the document.");
    public static final AttributeDefinition CHART_TITLE = new AttributeDefinition("title", 4, false, "The title of the chart.", "Use text-chart-item named 'title' instead.");
    public static final AttributeDefinition CHART_TITLE_FONT = new AttributeDefinition("title-font", 12, false, "The font to use for the chart title rendering.", "Use text-chart-item named 'title' instead.");
    public static final AttributeDefinition CHART_TYPE = new AttributeDefinition("type", 12, false, "The chart type, currently supported types are 'line-2d', 'bar-2d', 'pie-2d', 'pie-3d' and 'donut-3d'.");
    public static final AttributeDefinition CHART_INSTANCE = new AttributeDefinition("instance", 4, false, "An expression, resolving to a chart instance.");
    public static final AttributeDefinition PDF_VERSION = new AttributeDefinition("pdfversion", 1, false, "The Version of the generated PDF.");
    public static final AttributeDefinition LOGICAL_PAGENUMBERING = new AttributeDefinition("logical-pagestyle", 1, false, "The Logical Page Numbering style of the generated PDF (0: arabic numerals, 1: uppercase roman numerals, 2: lowercase roman numerals, 3: uppercase letters, 4: lowercase letters, 5: empty (No logical page numbers are generated but fixed text may still exist)).");
    public static final AttributeDefinition LOGICAL_PAGETEXT = new AttributeDefinition("logical-pagetext", 4, false, "The Logical Page Numbering style text of the generated PDF.");
    public static final AttributeDefinition PARAM_NAME = new AttributeDefinition("name", 12, true, "The name of the paremeter.");
    public static final AttributeDefinition PROPERTY_NAME = new AttributeDefinition("name", 12, true, "The name of the property to set.");
    public static final AttributeDefinition PROPERTY_TYPE = new AttributeDefinition("type", new String[]{"int", "float", "long", "double", "String", "Date", "Time", "Timestamp", "Object"}, true, "The type of the property to set, supported types are: int, long, float, double, String, Date, Time, Timestamp and Object.");
    public static final AttributeDefinition PROPERTY_VALUE = new AttributeDefinition("value", 4, false, "The value to set for the property. In case of numeric or date/time values international format will be used for parsing.");
    public static final AttributeDefinition PROPERTY_A = new AttributeDefinition("a", 4, false, "The first value to set for the property. In case of numeric or date/time values international format will be used for parsing.");
    public static final AttributeDefinition PROPERTY_B = new AttributeDefinition("b", 4, false, "The second value to set for the property. In case of numeric or date/time values international format will be used for parsing.");
    public static final AttributeDefinition FORMAT = new AttributeDefinition("format", 4, false, "The format to use for output of numeric or date values.");
}

