/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;

public class EncryptionTag
extends BaseDocumentTag {
    private static final AttributeDefinition ENCRYPTION_TYPE = new AttributeDefinition("encryption-type", new String[]{"40bit", "128bit", "AES128"}, false, "Defines the encryption bit strength, defaults to '128bit'.");
    private static final AttributeDefinition OWNER_PASSWORD = new AttributeDefinition("owner-password", 4, false, "Defines the user password to be added to the document.");
    private static final AttributeDefinition USER_PASSWORD = new AttributeDefinition("user-password", 4, false, "Defines the owner password to be added to the document.");
    private static final AttributeDefinition ALLOW_PRINTING = new AttributeDefinition("allow-printing", 3, false, "Defines permission to print the document.");
    private static final AttributeDefinition ALLOW_MODIFY_CONTENTS = new AttributeDefinition("allow-modify-contents", 3, false, "Defines permission to modify the contents of the document.");
    private static final AttributeDefinition ALLOW_COPY = new AttributeDefinition("allow-copy", 3, false, "Defines permission to copy the document.");
    private static final AttributeDefinition ALLOW_MODIFY_ANNOTATIONS = new AttributeDefinition("allow-modify-annotations", 3, false, "Defines permission to modify annotions of the document.");
    private static final AttributeDefinition ALLOW_FILLIN = new AttributeDefinition("allow-fillin", 3, false, "Defines permission to fill in the document as a form.");
    private static final AttributeDefinition ALLOW_SCREEN_READERS = new AttributeDefinition("allow-screen-readers", 3, false, "Defines permission to use screen readers with document.");
    private static final AttributeDefinition ALLOW_ASSEMBLY = new AttributeDefinition("allow-assembly", 3, false, "Defines permission to do assembly with the document.");
    private static final AttributeDefinition ALLOW_DEGRADED_PRINTING = new AttributeDefinition("allow-degraded-printing", 3, false, "Defines permission to print a degraded rendition of the document.");
    public static final String TAG_NAME = "encryption";

    public EncryptionTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Specifies the encryption for the generated document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(ENCRYPTION_TYPE).addDefinition(USER_PASSWORD).addDefinition(OWNER_PASSWORD).addDefinition(ALLOW_PRINTING).addDefinition(ALLOW_MODIFY_CONTENTS).addDefinition(ALLOW_COPY).addDefinition(ALLOW_MODIFY_ANNOTATIONS).addDefinition(ALLOW_FILLIN).addDefinition(ALLOW_SCREEN_READERS).addDefinition(ALLOW_ASSEMBLY).addDefinition(ALLOW_DEGRADED_PRINTING);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        DocWriter writer = this.getDocumentHandler().getDocumentWriter(false);
        if (!(writer instanceof PdfWriter)) {
            throw new DocumentHandlerException(this.locator(), "Encryption is only supported for PDF documents.", null);
        }
        PdfWriter pdfWriter = (PdfWriter)writer;
        int encryptionType = 1;
        int encryptionPermissions = 0;
        String userPassword = null;
        String ownerPassword = null;
        if (this.isAttributeDefined(ENCRYPTION_TYPE)) {
            String attr = this.getStringAttribute(ENCRYPTION_TYPE, true, null);
            if ("40bit".equals(attr)) {
                encryptionType = 0;
            } else if ("AES128".equals(attr)) {
                encryptionType = 2;
            }
        }
        if (this.isAttributeDefined(USER_PASSWORD)) {
            userPassword = this.getStringAttribute(USER_PASSWORD, false, null);
        }
        if (this.isAttributeDefined(OWNER_PASSWORD)) {
            ownerPassword = this.getStringAttribute(OWNER_PASSWORD, false, null);
        }
        if (this.getBooleanAttribute(ALLOW_PRINTING, false, true, null)) {
            encryptionPermissions |= 0x804;
        }
        if (this.getBooleanAttribute(ALLOW_MODIFY_CONTENTS, false, true, null)) {
            encryptionPermissions |= 8;
        }
        if (this.getBooleanAttribute(ALLOW_COPY, false, true, null)) {
            encryptionPermissions |= 0x10;
        }
        if (this.getBooleanAttribute(ALLOW_MODIFY_ANNOTATIONS, false, true, null)) {
            encryptionPermissions |= 0x20;
        }
        if (this.getBooleanAttribute(ALLOW_FILLIN, false, true, null)) {
            encryptionPermissions |= 0x100;
        }
        if (this.getBooleanAttribute(ALLOW_SCREEN_READERS, false, true, null)) {
            encryptionPermissions |= 0x200;
        }
        if (this.getBooleanAttribute(ALLOW_ASSEMBLY, false, true, null)) {
            encryptionPermissions |= 0x400;
        }
        if (this.getBooleanAttribute(ALLOW_DEGRADED_PRINTING, false, true, null)) {
            encryptionPermissions |= 4;
        }
        try {
            pdfWriter.setEncryption(userPassword != null ? userPassword.getBytes() : null, ownerPassword != null ? ownerPassword.getBytes() : null, encryptionPermissions, encryptionType);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to set document encryption: " + ex.getMessage(), ex);
        }
    }
}

