/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.DocumentEvent;
import org.ujac.print.DocumentEventRecorder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PagePosition;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.util.StringUtils;
import org.ujac.util.template.TemplateException;

public abstract class HeaderFooterPartTag
extends BaseDocumentTag
implements PhraseHolder,
ElementContainer,
DocumentEventRecorder,
Condition,
StyleHolder {
    public static final AttributeDefinition X = new AttributeDefinition("x", 14, false, "The fixed horizontal position of this part. In case you've specified a negative value, the part will be placed relative to the right page border");
    public static final AttributeDefinition WIDTH = new AttributeDefinition("width", 14, false, "The fixed width of this part.");
    protected PagePosition pos = null;
    protected float width = 0.0f;
    protected PdfPTable nestedTable = null;
    private DocumentEventRecorder parentEventRecorder = null;
    private boolean insertItems = false;
    private List documentEvents = new ArrayList();
    private Phrase phrase = null;
    protected int hAlign = 0;
    protected List items = null;

    public HeaderFooterPartTag(String name) {
        super(name);
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 1));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parentEventRecorder = this.documentHandler.topEventRecorder();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.documentHandler.pushEventRecorder(this);
        if (!this.isValid()) {
            return;
        }
        this.insertItems = false;
        if (this.isAttributeDefined(X)) {
            float xPos = this.getDimensionAttribute(X, true, X);
            this.pos = new PagePosition(xPos, 0.0f);
        }
        this.width = this.getDimensionAttribute(WIDTH, 0.0f, true, WIDTH);
        this.items = new ArrayList();
        this.nestedTable = null;
    }

    public void closeItem() throws DocumentHandlerException {
        this.documentHandler.popEventRecorder();
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
        if (this.phrase != null) {
            this.items.add(new ContentPart(this.phrase));
            this.phrase = null;
        }
        if (this.nestedTable != null && this.width <= 0.0f) {
            throw new TagAttributeException(this.locator(), "You need to define a fixed width if nested tables are used within your header or footer part.");
        }
    }

    protected abstract float getVerticalPosition(Document var1);

    private Phrase clonePhrase(Phrase phrase) {
        try {
            if (phrase == null) {
                return null;
            }
            Phrase clone = null;
            ArrayList chunks = phrase.getChunks();
            int numChunks = chunks.size();
            for (int i = 0; i < numChunks; ++i) {
                Chunk chunk = (Chunk)chunks.get(i);
                Chunk clonedChunk = null;
                HashMap attribs = chunk.getAttributes();
                clonedChunk = attribs != null && attribs.get("IMAGE") != null ? chunk : new Chunk(this.documentHandler.executeTemplate(chunk.getContent()), chunk.getFont());
                if (clone == null) {
                    clone = new Phrase(clonedChunk);
                    continue;
                }
                clone.add((Object)clonedChunk);
            }
            return clone;
        }
        catch (TemplateException ex) {
            throw new RuntimeException("Content evaluation failed: " + ex.getMessage());
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        int pageNumber = this.documentHandler.getPageNumber(writer);
        float verticalPosition = this.getVerticalPosition(document);
        boolean addNumberOfPages = false;
        this.phrase = null;
        this.items.clear();
        try {
            this.insertItems = true;
            this.repeatChildItems();
        }
        catch (DocumentHandlerException ex) {
            this.log.error((Object)(this.getName() + " output failed:" + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException(this.getName() + " output failed:" + ex.getMessage());
        }
        DocumentFont font = this.getFont();
        float textWidth = 0.0f;
        Phrase contentPhrase = null;
        int numItems = this.items.size();
        block12: for (int i = 0; i < numItems; ++i) {
            ContentPart item = (ContentPart)this.items.get(i);
            switch (item.getType()) {
                case 1: {
                    Phrase tmpPhrase = this.clonePhrase(item.getContent());
                    textWidth += this.getPhraseWidth(tmpPhrase);
                    if (contentPhrase == null) {
                        contentPhrase = tmpPhrase;
                        continue block12;
                    }
                    if (tmpPhrase == null) continue block12;
                    contentPhrase.add((Object)tmpPhrase);
                    continue block12;
                }
                case 2: {
                    Phrase pageNumberItem = new Phrase(Integer.toString(pageNumber), font.getFont());
                    textWidth += this.getPhraseWidth(pageNumberItem);
                    if (contentPhrase == null) {
                        contentPhrase = pageNumberItem;
                        continue block12;
                    }
                    contentPhrase.add((Object)pageNumberItem);
                    continue block12;
                }
                case 3: {
                    addNumberOfPages = true;
                }
            }
        }
        PdfContentByte cb = writer.getDirectContent();
        PdfTemplate numberOfPagesTemplate = null;
        float numberOfPagesWidth = 0.0f;
        float totalWidth = textWidth;
        if (addNumberOfPages) {
            numberOfPagesTemplate = this.ensureNumberOfPagesTemplate(font, cb);
            numberOfPagesWidth = numberOfPagesTemplate.getWidth();
            totalWidth += numberOfPagesWidth;
        }
        float effectiveWidth = totalWidth;
        if (this.nestedTable != null) {
            effectiveWidth = this.width;
        }
        float horizontalPosition = -1.0f;
        if (this.pos == null) {
            switch (this.hAlign) {
                case 0: {
                    horizontalPosition = document.left();
                    break;
                }
                case 2: {
                    horizontalPosition = document.right() - effectiveWidth;
                    break;
                }
                case 1: {
                    horizontalPosition = document.left() + (document.right() - document.left()) / 2.0f - effectiveWidth / 2.0f;
                    break;
                }
                default: {
                    horizontalPosition = document.left();
                    break;
                }
            }
        } else {
            Rectangle pageSize = document.getPageSize();
            horizontalPosition = this.pos.calcX(pageSize.getRight(), this.width);
        }
        Color bgColor = this.getBackgroundColor();
        PdfPTable table = new PdfPTable(1);
        PdfPCell contentCell = null;
        if (this.nestedTable == null) {
            contentCell = new PdfPCell(contentPhrase);
            contentCell.setPadding(0.0f);
            contentCell.setBorder(0);
            contentCell.setBorderWidth(0.0f);
            if (this.pos != null && this.width >= 0.0f) {
                contentCell.setHorizontalAlignment(this.hAlign);
            }
            if (bgColor != null) {
                contentCell.setBackgroundColor(bgColor);
            }
            table.addCell(contentCell);
            table.setTotalWidth(Math.max(effectiveWidth + 1.0f, this.width));
        } else {
            contentCell = new PdfPCell(this.nestedTable);
            contentCell.setPadding(0.0f);
            contentCell.setBorder(0);
            contentCell.setBorderWidth(0.0f);
            if (this.pos != null && this.width >= 0.0f) {
                contentCell.setHorizontalAlignment(this.hAlign);
            }
            if (bgColor != null) {
                contentCell.setBackgroundColor(bgColor);
            }
            table.addCell(contentCell);
            table.setTotalWidth(this.width);
        }
        table.writeSelectedRows(0, 1, horizontalPosition, verticalPosition + table.getRowHeight(0), cb);
        if (addNumberOfPages) {
            cb.addTemplate(numberOfPagesTemplate, horizontalPosition + textWidth, verticalPosition - 1.0f);
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
    }

    protected void parseContent(String content) throws DocumentHandlerException {
        if (content == null) {
            return;
        }
        if (this.phrase != null) {
            this.items.add(new ContentPart(this.phrase));
            this.phrase = null;
        }
        char[] contentChars = content.toCharArray();
        char c = '\u0000';
        int itemStart = 0;
        block0: for (int i = 0; i < contentChars.length; ++i) {
            String phraseText;
            c = contentChars[i];
            if (c != '$') continue;
            int startIdx = i++;
            c = contentChars[i];
            if (c != '{') continue;
            if (i - itemStart > 2 && (phraseText = new String(contentChars, itemStart, i - itemStart - 1)).length() > 0) {
                this.items.add(new ContentPart(this.addChunk(this, null, phraseText, this.getFont(), this.getLeading(), this.getLineSpacing())));
                itemStart = i - 1;
            }
            while (i < contentChars.length) {
                c = contentChars[i];
                if (c == '}') {
                    String exprToken = new String(contentChars, startIdx, i - startIdx + 1);
                    if ("${pageNumber}".equals(exprToken)) {
                        this.items.add(new ContentPart(2));
                        itemStart = i + 1;
                        continue block0;
                    }
                    if (!"${pageCount}".equals(exprToken)) continue block0;
                    this.items.add(new ContentPart(3));
                    itemStart = i + 1;
                    continue block0;
                }
                ++i;
            }
        }
        if (itemStart < contentChars.length) {
            String lastPhraseText = new String(contentChars, itemStart, contentChars.length - itemStart);
            this.items.add(new ContentPart(this.addChunk(this, null, lastPhraseText, this.getFont(), this.getLeading(), this.getLineSpacing())));
        }
    }

    public void flushContent() throws DocumentHandlerException {
        if (!this.isTrue()) {
            return;
        }
        if (this.isItemClosed()) {
            this.trimContentTail();
        }
        this.parseContent(this.getContent());
        this.resetContent();
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (!this.isTrue()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
            if (this.isTrimBody()) {
                chunk = StringUtils.trimHead(chunk);
            }
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
        this.items.add(new ContentPart(this.phrase));
        this.phrase = null;
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) {
        if (!this.isTrue()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
        this.items.add(new ContentPart(this.phrase));
        this.phrase = null;
    }

    public float getLeading() {
        return 0.0f;
    }

    public abstract float getLineSpacing();

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (!this.isTrue()) {
            return;
        }
        if (!(element instanceof PdfPTable)) {
            throw new DocumentHandlerException(this.locator(), "Only tables are allowed here.");
        }
        if (this.width == 0.0f) {
            throw new TagAttributeException(this.locator(), "You need to define the absolute 'width' for <" + this.getName() + "> tags with nested <table> elements.");
        }
        this.nestedTable = (PdfPTable)element;
    }

    public boolean isTopLevel() {
        return false;
    }

    protected void repeatChildItems() throws DocumentHandlerException {
        this.setItemClosed(false);
        int numEvents = this.documentEvents.size();
        block5: for (int i = 0; i < numEvents; ++i) {
            DocumentEvent event = (DocumentEvent)this.documentEvents.get(i);
            BaseDocumentTag item = event.getItem();
            if (i == numEvents - 1) {
                this.setItemClosed(true);
            }
            switch (event.getType()) {
                case 1: {
                    BaseDocumentTag topItem = item.getParentItem();
                    if (topItem != null) {
                        topItem.flushContent();
                    }
                    this.documentHandler.pushItem(item);
                    item.openItem();
                    continue block5;
                }
                case 2: {
                    String content = event.getContent();
                    if (content.length() <= 0) continue block5;
                    item.setItemOpened(false);
                    item.addContent(content);
                    if (i != numEvents - 1) continue block5;
                    item.flushContent();
                    continue block5;
                }
                case 3: {
                    item.setItemClosed(true);
                    item.flushContent();
                    item.closeItem();
                    this.documentHandler.popItem();
                    continue block5;
                }
                default: {
                    throw new DocumentHandlerException(this.locator(), "Encountered illegal event type '" + event.getType() + "!");
                }
            }
        }
    }

    public void recordEvent(DocumentEvent event) {
        if (event.getItem() != this) {
            this.documentEvents.add(event);
        } else if (event.getType() == 2) {
            this.documentEvents.add(event);
            this.resetContent();
        } else if (this.parentEventRecorder != null) {
            this.parentEventRecorder.recordEvent(event);
        }
    }

    public boolean isTrue() {
        return this.insertItems;
    }

    class ContentPart {
        public static final int TYPE_PHRASE = 1;
        public static final int TYPE_PAGE_NUMBER = 2;
        public static final int TYPE_NUMBER_OF_PAGES = 3;
        private int type;
        private Phrase contentPhrase = null;

        public ContentPart(int type) {
            this.type = type;
        }

        public ContentPart(Phrase contentPhrase) {
            this.type = 1;
            this.contentPhrase = contentPhrase;
        }

        public int getType() {
            return this.type;
        }

        public Phrase getContent() {
            return this.contentPhrase;
        }
    }
}

