/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ItemHolder;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.ParameterHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ItemTag;
import org.ujac.print.tag.ItemsTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.template.TemplateException;

public class ParameterTag
extends BaseDocumentTag
implements ItemHolder {
    public static final String TAG_NAME = "parameter";
    private ParameterHolder parameterHolder = null;
    private String name = null;
    private List items = null;

    public ParameterTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a parameter to its surrounding parameter holder.This could be a macro for example. There must be a according parameter definition for each parameter. The parameter value is determined from the item's body.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.PARAM_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ItemsTag.class, 0, 999)).addDefinition(new ChildDefinition(ItemTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999));
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parameterHolder = (ParameterHolder)((Object)this.documentHandler.latestOfType(ParameterHolder.class));
        if (this.parameterHolder == null) {
            throw new DocumentHandlerException(this.locator(), "Item '" + this.getName() + "' is not supported here.");
        }
        this.name = this.getStringAttribute(CommonAttributes.PARAM_NAME, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.items = null;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        ParameterDefinition paramDef = this.parameterHolder.getParameterDefinition(this.name);
        if (paramDef == null) {
            throw new TagAttributeException(this.locator(), "Detected unsupported parameter '" + this.name + "'.");
        }
        String expr = this.getContent();
        Object value = null;
        if (this.items != null) {
            value = this.items;
        } else if (paramDef.isList()) {
            value = expr;
        } else {
            try {
                switch (paramDef.getType()) {
                    case 7: {
                        value = new Boolean(this.documentHandler.evalBoolean(expr));
                        break;
                    }
                    case 2: {
                        value = new Integer(this.documentHandler.evalInt(expr));
                        break;
                    }
                    case 5: {
                        value = new Float(this.documentHandler.evalFloat(expr));
                        break;
                    }
                    case 6: {
                        value = new Double(this.documentHandler.evalDouble(expr));
                        break;
                    }
                    case 8: {
                        value = this.documentHandler.evalDate(expr);
                        break;
                    }
                    case 1: 
                    case 20: 
                    case 21: 
                    case 22: {
                        if (!paramDef.isList()) {
                            value = this.documentHandler.executeTemplate(expr);
                            break;
                        }
                    }
                    default: {
                        value = this.documentHandler.evalObject(expr);
                        break;
                    }
                }
            }
            catch (TemplateException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
        }
        this.parameterHolder.setParameter(this.name, value);
    }

    public void addItem(Object item) throws TagAttributeException {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
    }

    public Object parseItem(String text) throws TagAttributeException {
        ParameterDefinition paramDef = this.parameterHolder.getParameterDefinition(this.name);
        if (paramDef == null) {
            throw new TagAttributeException(this.locator(), "Detected unsupported parameter '" + this.name + "'.");
        }
        try {
            Object value = null;
            try {
                switch (paramDef.getType()) {
                    case 7: {
                        value = new Boolean(this.documentHandler.evalBoolean(text));
                        break;
                    }
                    case 2: {
                        value = new Integer(this.documentHandler.evalInt(text));
                        break;
                    }
                    case 5: {
                        value = new Float(this.documentHandler.evalFloat(text));
                        break;
                    }
                    case 6: {
                        value = new Double(this.documentHandler.evalDouble(text));
                        break;
                    }
                    case 8: {
                        value = this.documentHandler.evalDate(text);
                        break;
                    }
                    case 1: 
                    case 20: 
                    case 21: {
                        value = this.documentHandler.evalString(text);
                        break;
                    }
                    case 22: {
                        value = this.colorFromString(this.name, text, true);
                        break;
                    }
                    default: {
                        value = this.documentHandler.evalObject(text);
                        break;
                    }
                }
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
            return value;
        }
        catch (DocumentHandlerException ex) {
            throw new TagAttributeException(ex.getLocator(), ex.getMessage(), ex.getOriginalCause());
        }
    }
}

