/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfHelper;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.PdfCellBlockTag;
import org.ujac.print.tag.PdfCellTag;
import org.ujac.print.tag.PdfTableHeaderTag;
import org.ujac.print.tag.PdfTableRowTag;
import org.ujac.print.tag.PdfTableSplitTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TocTag;
import org.ujac.util.exi.ExpressionException;
import org.xml.sax.Locator;

public class PdfTableTag
extends BaseElementTag
implements PdfCellContainer,
PdfTableHolder,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "table";
    private static final AttributeDefinition BACKGROUND_COLOR = CommonAttributes.BACKGROUND_COLOR.cloneAttrDef("Defines the default background color for the nested cells.");
    private static final AttributeDefinition BACKGROUND_COLOR_STYLE = CommonStyleAttributes.BACKGROUND_COLOR.cloneAttrDef("Defines the default background color for the nested cells.");
    private static final AttributeDefinition BORDER_STYLE = CommonAttributes.BORDER_STYLE.cloneAttrDef("Defines the default border type for the nested cells.");
    private static final AttributeDefinition BORDER_STYLE_STYLE = CommonStyleAttributes.BORDER_STYLE.cloneAttrDef("Defines the default border type for the nested cells.");
    private static final AttributeDefinition BORDER_WIDTH = CommonAttributes.BORDER_WIDTH.cloneAttrDef("Defines the default border width for the nested cells.");
    private static final AttributeDefinition BORDER_WIDTH_STYLE = CommonStyleAttributes.BORDER_WIDTH.cloneAttrDef("Defines the default border width for the nested cells.");
    private static final AttributeDefinition BORDER_COLOR = CommonAttributes.BORDER_COLOR.cloneAttrDef("Defines the default border color for the nested cells.");
    private static final AttributeDefinition BORDER_COLOR_STYLE = CommonStyleAttributes.BORDER_COLOR.cloneAttrDef("Defines the default border color for the nested cells.");
    private static final AttributeDefinition PADDING = CommonAttributes.PADDING.cloneAttrDef("Defines the default padding for the nested cells.");
    private static final AttributeDefinition PADDING_STYLE = CommonStyleAttributes.PADDING.cloneAttrDef("Defines the default padding for the nested cells.");
    private static final AttributeDefinition PADDING_LEFT = CommonAttributes.PADDING_LEFT.cloneAttrDef("Defines the default left padding for the nested cells.");
    private static final AttributeDefinition PADDING_LEFT_STYLE = CommonStyleAttributes.PADDING_LEFT.cloneAttrDef("Defines the default left padding for the nested cells.");
    private static final AttributeDefinition PADDING_RIGHT = CommonAttributes.PADDING_RIGHT.cloneAttrDef("Defines the default right padding for the nested cells.");
    private static final AttributeDefinition PADDING_RIGHT_STYLE = CommonStyleAttributes.PADDING_RIGHT.cloneAttrDef("Defines the default right padding for the nested cells.");
    private static final AttributeDefinition PADDING_TOP = CommonAttributes.PADDING_TOP.cloneAttrDef("Defines the default top padding for the nested cells.");
    private static final AttributeDefinition PADDING_TOP_STYLE = CommonStyleAttributes.PADDING_TOP.cloneAttrDef("Defines the default top padding for the nested cells.");
    private static final AttributeDefinition PADDING_BOTTOM = CommonAttributes.PADDING_BOTTOM.cloneAttrDef("Defines the default bottom padding for the nested cells.");
    private static final AttributeDefinition PADDING_BOTTOM_STYLE = CommonStyleAttributes.PADDING_BOTTOM.cloneAttrDef("Defines the default bottom padding for the nested cells.");
    public static final int MAX_SEGMENT_SIZE = 100;
    private PdfCellContainer pdfCellContainer = null;
    private CellAttributes cellAttributes = null;
    private PdfPTable table = null;
    private BaseDocumentTag latestChild = null;
    private List headerItems = new ArrayList();
    private int numCells = 0;
    private int numRows = 0;
    private int columns = 0;
    private float width = 0.0f;
    private String widthsAttr = null;
    private float[] widths = null;
    private int hAlign = 0;
    private boolean splitRows = false;
    private boolean splitLate = true;
    private float spacingBefore = 0.0f;
    private float spacingAfter = 0.0f;
    private boolean keepTogether = false;

    public PdfTableTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a table to its parent item. Tables are very useful if you want to layout your document nicely.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.TABLE_COLUMNS).addDefinition(CommonAttributes.TABLE_WIDTHS).addDefinition(CommonAttributes.TABLE_WIDTH).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(BACKGROUND_COLOR).addDefinition(BORDER_STYLE).addDefinition(BORDER_WIDTH).addDefinition(BORDER_COLOR).addDefinition(PADDING).addDefinition(PADDING_LEFT).addDefinition(PADDING_RIGHT).addDefinition(PADDING_TOP).addDefinition(PADDING_BOTTOM).addDefinition(CommonAttributes.TABLE_SPLIT_ROWS).addDefinition(CommonAttributes.TABLE_SPLIT_LATE).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.KEEP_TOGETHER);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.TABLE_WIDTH).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(BACKGROUND_COLOR_STYLE).addDefinition(BORDER_STYLE_STYLE).addDefinition(BORDER_WIDTH_STYLE).addDefinition(BORDER_COLOR_STYLE).addDefinition(PADDING_STYLE).addDefinition(PADDING_LEFT_STYLE).addDefinition(PADDING_RIGHT_STYLE).addDefinition(PADDING_TOP_STYLE).addDefinition(PADDING_BOTTOM_STYLE).addDefinition(CommonStyleAttributes.TABLE_SPLIT_ROWS).addDefinition(CommonStyleAttributes.TABLE_SPLIT_LATE).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.KEEP_TOGETHER);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(TocTag.class, 0, 999)).addDefinition(new ChildDefinition(IndexTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableHeaderTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableRowTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfCellTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableSplitTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfCellBlockTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public int getNumColumns() {
        return this.columns;
    }

    public int getNumContentRows() {
        if (this.table == null) {
            return 0;
        }
        return this.table.size() - this.table.getHeaderRows();
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.pdfCellContainer = this.documentHandler.latestPdfCellContainer();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        CellAttributes parentAttributes = null;
        if (this.pdfCellContainer != null) {
            parentAttributes = this.pdfCellContainer.getCellAttributes();
        }
        this.cellAttributes.parseTableAttributes(this, parentAttributes);
        this.columns = this.getIntegerAttribute(CommonAttributes.TABLE_COLUMNS, true, null);
        this.widthsAttr = this.getStringAttribute(CommonAttributes.TABLE_WIDTHS, true, null);
        this.width = this.getFloatAttribute(CommonAttributes.TABLE_WIDTH, 100.0f, true, CommonStyleAttributes.TABLE_WIDTH);
        this.spacingBefore = this.getDimensionAttribute(CommonAttributes.SPACING_BEFORE, 0.0f, true, CommonStyleAttributes.SPACING_BEFORE);
        this.spacingAfter = this.getDimensionAttribute(CommonAttributes.SPACING_AFTER, 0.0f, true, CommonStyleAttributes.SPACING_AFTER);
        this.keepTogether = this.getBooleanAttribute(CommonAttributes.KEEP_TOGETHER, false, true, CommonStyleAttributes.KEEP_TOGETHER);
        if (this.widthsAttr != null) {
            StringTokenizer tkn = null;
            try {
                tkn = new StringTokenizer(this.documentHandler.evalString(this.widthsAttr), ",");
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
            this.columns = tkn.countTokens();
            this.widths = new float[this.columns];
            int idx = 0;
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                try {
                    this.widths[idx] = Float.parseFloat(token);
                    ++idx;
                }
                catch (NumberFormatException ex) {
                    throw new TagAttributeException(this.locator(), "Attribute widths must hold a list of floating point numbers, separated by ',' (was '" + token + "').", ex);
                }
            }
        } else if (this.isAttributeDefined(CommonAttributes.TABLE_COLUMNS)) {
            this.widths = new float[this.columns];
            float averageWidth = 100.0f / (float)this.columns;
            for (int i = 0; i < this.columns; ++i) {
                this.widths[i] = averageWidth;
            }
        } else {
            throw new TagAttributeException(this.locator(), "Eighter attribute 'widths' or 'columns' has to be defined for tag <" + this.getName() + ">.");
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.splitRows = this.getBooleanAttribute(CommonAttributes.TABLE_SPLIT_ROWS, false, CommonStyleAttributes.TABLE_SPLIT_ROWS);
        this.splitLate = this.getBooleanAttribute(CommonAttributes.TABLE_SPLIT_LATE, false, CommonStyleAttributes.TABLE_SPLIT_LATE);
        if (this.columns == 0) {
            throw new TagAttributeException(this.locator(), "Tables have to hold at least one column!");
        }
        this.openItem(true);
    }

    public void openItem(boolean resetData) throws DocumentHandlerException {
        if (resetData) {
            this.numCells = 0;
            this.headerItems.clear();
        }
        if (!this.isValid()) {
            return;
        }
        this.table = new PdfPTable(this.columns);
        if (this.width > 0.0f) {
            this.table.setWidthPercentage(this.width);
        }
        if (this.widths != null) {
            try {
                this.table.setWidths(this.widths);
            }
            catch (DocumentException ex) {
                throw new DocumentHandlerException(this.locator(), "Invalid table widths:'" + this.getStringAttribute(CommonAttributes.TABLE_WIDTHS, true, null) + "': " + ex.getMessage(), ex);
            }
        }
        this.table.setHorizontalAlignment(this.hAlign);
        this.table.setSplitRows(this.splitRows);
        this.table.setSplitLate(this.splitLate);
        if (resetData) {
            this.table.setSpacingBefore(this.spacingBefore);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushTableSegment(true);
    }

    private void flushTableSegment(boolean lastSegment) throws DocumentHandlerException {
        if (this.numCells % this.columns > 0) {
            Locator locator = this.locator();
            if (this.latestChild != null) {
                locator = this.latestChild.locator();
            }
            throw new DocumentHandlerException(locator, "The last row is not filled completely, check the table cells!");
        }
        if (lastSegment) {
            this.table.setSpacingAfter(this.spacingAfter);
        }
        if (this.keepTogether && !this.fitsPage()) {
            this.documentHandler.getDocument().newPage();
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.table);
        this.numCells = 0;
        this.numRows = 0;
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        this.latestChild = item;
        this.numCells += Math.max(cell.getColspan(), 1);
        this.table.addCell(cell);
        if (this.numCells % this.columns == 0) {
            ++this.numRows;
            if (!this.keepTogether && this.numRows >= 100) {
                this.splitTable(false, true);
            }
        }
    }

    public int getRemainingPdfColumns() {
        return this.columns - this.numCells % this.columns;
    }

    public PdfTableHolder getPdfTable() {
        return this;
    }

    public void addHeaderCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        this.addCell(item, cell);
        this.headerItems.add(cell);
    }

    public PdfPTable getTable() {
        return this.table;
    }

    public boolean fitsPage() throws DocumentHandlerException {
        DocumentHandler documentHandler = this.getDocumentHandler();
        PdfWriter writer = (PdfWriter)documentHandler.getDocumentWriter();
        try {
            return PdfHelper.fitsPage(writer, documentHandler.getDocument(), this.getTable());
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Fits page check failed: " + ex.getMessage(), ex);
        }
    }

    public boolean splitTable(boolean newPage, boolean keepHeader) throws DocumentHandlerException {
        if (!this.isValid()) {
            return false;
        }
        if (keepHeader && !newPage && this.numCells < 1) {
            return false;
        }
        int numHeaderRows = this.table.getHeaderRows();
        this.flushTableSegment(false);
        if (newPage) {
            try {
                this.documentHandler.getDocument(true).newPage();
            }
            catch (Exception ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to open a new page: " + ex.getMessage(), ex);
            }
        }
        this.openItem(false);
        if (keepHeader) {
            if (!newPage) {
                this.table.setSkipFirstHeader(true);
            }
            int numHeaderItems = this.headerItems.size();
            for (int i = 0; i < numHeaderItems; ++i) {
                PdfPCell headerItem = (PdfPCell)this.headerItems.get(i);
                this.table.addCell(headerItem);
            }
            this.table.setHeaderRows(numHeaderRows);
        } else {
            this.headerItems.clear();
        }
        return true;
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }

    public float getLineSpacing() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLineSpacing();
        }
        return 1.2f;
    }

    public float getLeading() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLeading();
        }
        return 0.0f;
    }
}

