/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.PdfChunk;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.ChartTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SwitchTag;

public class PhraseTag
extends BaseElementTag
implements ElementContainer,
PhraseHolder,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "phrase";
    public static final SplitCharacter NO_SPLIT = new SplitCharacter(){

        public boolean isSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
            return false;
        }
    };
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    private float rotate = 0.0f;
    private boolean noWrap = false;
    private Phrase phrase = null;

    public PhraseTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a phrase to its parent item.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.ROTATE).addDefinition(CommonAttributes.TRIM_BODY).addDefinition(CommonAttributes.NO_WRAP).addDefinition(CommonAttributes.BACKGROUND_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.ROTATE).addDefinition(CommonStyleAttributes.NO_WRAP).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ChartTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(SpaceTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.phrase = null;
        if (!this.isValid()) {
            return;
        }
        CommonAttributesHolder commonAttributesHolder = this.getCommonAttributesHolder();
        this.leading = this.isAttributeDefined(CommonAttributes.LEADING, CommonStyleAttributes.LEADING) ? this.getDimensionAttribute(CommonAttributes.LEADING, true, CommonStyleAttributes.LEADING) : commonAttributesHolder.getLeading();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : commonAttributesHolder.getLineSpacing();
        this.rotate = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, true, CommonStyleAttributes.ROTATE);
        this.noWrap = this.getBooleanAttribute(CommonAttributes.NO_WRAP, false, true, CommonStyleAttributes.NO_WRAP);
        if (this.isAttributeSupported(CommonAttributes.TRIM_BODY)) {
            this.setTrimBody(this.getBooleanAttribute(CommonAttributes.TRIM_BODY, true, true, null));
        }
    }

    public String getActualContent() {
        if (this.phrase == null) {
            return super.getActualContent();
        }
        return this.getPhraseContent(this.phrase);
    }

    public void flushContent() throws DocumentHandlerException {
        Phrase nestedPhrase;
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.createPhrase();
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if ((nestedPhrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing())) != null) {
            this.phrase = nestedPhrase;
        }
        this.resetContent();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
        if (this.noWrap && this.phrase != null) {
            int numChunks = this.phrase.size();
            if (numChunks > 1) {
                StringBuffer contentBuf = new StringBuffer();
                for (int i = 0; i < numChunks; ++i) {
                    Chunk chunk = (Chunk)this.phrase.get(i);
                    contentBuf.append(chunk.getContent());
                }
                Chunk chunk = (Chunk)this.phrase.get(0);
                chunk = new Chunk(contentBuf.toString(), chunk.getFont());
                chunk.setSplitCharacter(NO_SPLIT);
                this.phrase.clear();
                this.phrase.add((Object)chunk);
            } else if (numChunks == 1) {
                Chunk chunk = (Chunk)this.phrase.get(0);
                chunk.setSplitCharacter(NO_SPLIT);
            }
        }
        if (this.rotate != 0.0f) {
            this.phrase = this.rotatePhrase(this.phrase, this.rotate);
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.phrase);
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.phrase.add((Object)element);
        if (element instanceof Phrase) {
            this.extendLeading(this.phrase, (Phrase)element);
        }
    }

    public boolean isTopLevel() {
        return false;
    }

    private void createPhrase() {
        this.phrase = new Phrase(0.0f);
    }
}

