/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.FontHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.PrintRowTag;
import org.ujac.print.tag.RowCellContainer;
import org.ujac.util.table.GroupRow;
import org.ujac.util.table.Row;

public class PrintGroupRowTag
extends PrintRowTag
implements FontHolder,
Condition,
RowCellContainer {
    public static final String TAG_NAME = "print-group-row";

    public PrintGroupRowTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Prints the contents of group rows.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.GROUP_NAME).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.CELL_HEIGHT).addDefinition(CommonAttributes.ROTATE).addDefinition(CommonAttributes.NO_WRAP);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.CELL_HEIGHT).addDefinition(CommonStyleAttributes.ROTATE).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public boolean isTrue() {
        Row currentRow = (Row)this.rowContainer.getCurrentValue();
        try {
            if (currentRow != null && "group".equals(currentRow.getType())) {
                String groupName = this.getStringAttribute(CommonAttributes.GROUP_NAME, true, null);
                GroupRow groupRow = (GroupRow)currentRow;
                return groupName == null || groupName.equals(groupRow.getGroupName());
            }
            return false;
        }
        catch (TagAttributeException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

