/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;

public class SetPropertyTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "set-property";
    private String name = null;
    private String type = null;

    public SetPropertyTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the value for a specific property.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.PROPERTY_NAME).addDefinition(CommonAttributes.PROPERTY_TYPE).addDefinition(CommonAttributes.PROPERTY_VALUE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.name = this.getStringAttribute(CommonAttributes.PROPERTY_NAME, false, null);
        this.type = this.getStringAttribute(CommonAttributes.PROPERTY_TYPE, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String valueAttr = this.getStringAttribute(CommonAttributes.PROPERTY_VALUE, false, null);
        Object value = this.typeCastValue(valueAttr, this.type);
        this.documentHandler.getTemplateContext().setProperty(this.name, value);
    }

    public boolean isStructureChecksDisabled() {
        return true;
    }
}

