/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.tag.BackgroundImageTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.BoxTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.SwitchTag;

public class StickyTag
extends BaseDocumentTag {
    private static final AttributeDefinition STICKY_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the sticky area.").setRequired(false);
    public static final String TAG_NAME = "sticky";
    protected NewPageTag newPageTag = null;
    private List stickyElementHandlers = new ArrayList();

    public StickyTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a sticky area. This area can contain background images and other absolutely positioned elements.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(STICKY_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(BackgroundImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BoxTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.newPageTag = (NewPageTag)this.documentHandler.latestOfType("new-page");
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.stickyElementHandlers.clear();
        super.openItem();
    }

    public void closeItem() throws DocumentHandlerException {
        super.closeItem();
        if (!this.isValid()) {
            return;
        }
        String key = "sticky-" + this.getStringAttribute(STICKY_NAME, "default", true, null);
        if (this.isInNewPageTag()) {
            this.newPageTag.queuePageEventHandler(key, (PdfPageEvent)new StickyPageEventHandler());
        } else {
            this.documentHandler.setPageEventHandler(key, (PdfPageEvent)new StickyPageEventHandler());
        }
    }

    public void addStickyElementHandler(DocumentPageEventHandler handler) {
        this.stickyElementHandlers.add(handler);
    }

    public List getStickyElementHandlers() {
        return this.stickyElementHandlers;
    }

    protected boolean isInNewPageTag() {
        return this.newPageTag != null;
    }

    class StickyPageEventHandler
    extends DocumentPageEventHandler {
        StickyPageEventHandler() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            List imageHandlers = StickyTag.this.getStickyElementHandlers();
            int numHandlers = imageHandlers.size();
            for (int i = 0; i < numHandlers; ++i) {
                ((DocumentPageEventHandler)((Object)imageHandlers.get(i))).onEndPage(writer, document);
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            List imageHandlers = StickyTag.this.getStickyElementHandlers();
            int numHandlers = imageHandlers.size();
            for (int i = 0; i < numHandlers; ++i) {
                ((DocumentPageEventHandler)((Object)imageHandlers.get(i))).onCloseDocument(writer, document);
            }
        }

        public boolean isTemporary() {
            return false;
        }
    }
}

