/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.transcoder.DefaultErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.ujac.print.DocumentHandler;
import org.ujac.print.tag.BaseImageBuilder;
import org.ujac.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SvgImageBuilder
extends BaseImageBuilder {
    public static final char[] SVG_DOC_TYPE_ID = "-//W3C//DTD SVG".toCharArray();

    @Override
    public boolean checkFormat(byte[] imageData) {
        if (!this.isXml(imageData)) {
            try {
                imageData = this.uncompress(imageData);
                if (!this.isXml(imageData)) {
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
        }
        int maxIdx = Math.max(imageData.length, 1024);
        int docTypeLength = SVG_DOC_TYPE_ID.length;
        block2: for (int i = 5; i < maxIdx; ++i) {
            if (imageData[i] != SVG_DOC_TYPE_ID[0]) continue;
            if (docTypeLength + i > maxIdx) {
                return false;
            }
            for (int j = 1; j < docTypeLength; ++j) {
                if (imageData[j + i] != SVG_DOC_TYPE_ID[j]) continue block2;
            }
            return true;
        }
        return false;
    }

    @Override
    public Image buildImage(DocumentHandler documentHandler, byte[] imageData, String path, float width, float height, int page) throws IOException {
        try {
            imageData = this.uncompress(imageData);
        }
        catch (IOException ex) {
            // empty catch block
        }
        Graphics graphics = null;
        try {
            SvgUserAgent userAgent = new SvgUserAgent(documentHandler);
            DocumentFactory documentFactory = new DocumentFactory(documentHandler, path);
            Document svgDoc = new SvgDocumentLoader((UserAgent)userAgent, (SVGDocumentFactory)documentFactory).loadDocument("file:image.svg", new ByteArrayInputStream(imageData));
            NodeList roots = svgDoc.getElementsByTagName("svg");
            Node root = roots.item(0);
            NamedNodeMap attrs = root.getAttributes();
            Node widthNode = attrs.getNamedItem("width");
            float imageWidth = Float.parseFloat(widthNode.getChildNodes().item(0).getNodeValue());
            Node heightNode = attrs.getNamedItem("height");
            float imageHeight = Float.parseFloat(heightNode.getChildNodes().item(0).getNodeValue());
            PdfWriter writer = (PdfWriter)documentHandler.getDocumentWriter();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(imageWidth, imageHeight);
            FontMapper fontMapper = documentHandler.getFontMapper();
            graphics = tp.createGraphics(imageWidth, imageHeight, fontMapper);
            ImageTranscoder prm = new ImageTranscoder((SVGDocumentFactory)documentFactory, (UserAgent)userAgent);
            String xmlReaderClassName = documentHandler.getXmlReaderClass();
            if (xmlReaderClassName != null) {
                prm.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, xmlReaderClassName);
            }
            final StringBuffer errorMsg = new StringBuffer();
            prm.setErrorHandler((org.apache.batik.transcoder.ErrorHandler)new DefaultErrorHandler(){

                public void error(TranscoderException ex) throws TranscoderException {
                    errorMsg.append(ex.getMessage());
                    ex.printStackTrace();
                    super.error(ex);
                }

                public void fatalError(TranscoderException ex) throws TranscoderException {
                    errorMsg.append(ex.getMessage());
                    ex.printStackTrace();
                    super.fatalError(ex);
                }

                public void warning(TranscoderException ex) throws TranscoderException {
                    super.warning(ex);
                }
            });
            TranscoderInput ti = new TranscoderInput(svgDoc);
            prm.transcode(ti, null);
            PageFormat pg = new PageFormat();
            Paper pp = new Paper();
            pp.setSize(width, height);
            pp.setImageableArea(0.0, 0.0, imageWidth, imageHeight);
            pg.setPaper(pp);
            prm.print(graphics, pg, 0);
            if (errorMsg.length() > 0) {
                throw new IOException(errorMsg.toString());
            }
            Image image = Image.getInstance((PdfTemplate)tp);
            return image;
        }
        catch (BadElementException ex) {
            throw new IOException("Unable to create image from SVG document: " + ex.getMessage());
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    private class ImageTranscoder
    extends PrintTranscoder {
        private SVGDocumentFactory documentFactory;
        private UserAgent userAgent;

        protected ImageTranscoder(SVGDocumentFactory documentFactory, UserAgent userAgent) {
            this.userAgent = userAgent;
            this.documentFactory = documentFactory;
        }

        protected BridgeContext createBridgeContext() {
            return new BridgeContext(this.userAgent, (DocumentLoader)new SvgDocumentLoader(this.userAgent, this.documentFactory));
        }
    }

    private class SvgDocumentLoader
    extends DocumentLoader {
        protected SvgDocumentLoader(UserAgent userAgent, SVGDocumentFactory factory) {
            super(userAgent);
            this.documentFactory = factory;
        }
    }

    private class DocumentFactory
    extends SAXSVGDocumentFactory {
        private DocumentHandler documentHandler;
        private String path;

        public DocumentFactory(DocumentHandler documentHandler, String path) {
            super(documentHandler.getXmlReaderClass());
            this.documentHandler = documentHandler;
            this.path = path;
        }

        public Document createDocument(String uri) throws IOException {
            int i;
            int eqIdx;
            ParsedURL purl = new ParsedURL(uri);
            InputStream is = null;
            if (uri.startsWith("file:") && this.path != null) {
                String resourceLocation = this.path + uri.substring(5);
                is = new ByteArrayInputStream(this.documentHandler.loadResource(resourceLocation));
            } else {
                is = purl.openStream(MimeTypeConstants.MIME_TYPES_SVG);
            }
            InputSource isrc = new InputSource(is);
            String contentType = purl.getContentType();
            int cindex = -1;
            if (contentType != null) {
                contentType = contentType.toLowerCase();
                cindex = contentType.indexOf("charset");
            }
            if (cindex != -1 && (eqIdx = contentType.indexOf(61, i = cindex + "charset".length())) != -1) {
                int idx = contentType.indexOf(44, ++eqIdx);
                int semiIdx = contentType.indexOf(59, eqIdx);
                if (semiIdx != -1 && (semiIdx < idx || idx == -1)) {
                    idx = semiIdx;
                }
                String charset = idx != -1 ? contentType.substring(eqIdx, idx) : contentType.substring(eqIdx);
                isrc.setEncoding(charset.trim());
            }
            isrc.setSystemId(uri);
            Document doc = super.createDocument("http://www.w3.org/2000/svg", "svg", uri, isrc);
            try {
                ((SVGOMDocument)doc).setURLObject(new URL(purl.toString()));
            }
            catch (MalformedURLException mue) {
                throw new IOException("Malformed URL: " + uri);
            }
            return doc;
        }

        protected Document createDocument(InputSource is) throws IOException {
            try {
                XMLReader parser = XmlUtils.createXmlReader(this.parserClassName);
                parser.setContentHandler((ContentHandler)((Object)this));
                parser.setDTDHandler((DTDHandler)((Object)this));
                parser.setEntityResolver((EntityResolver)((Object)this));
                parser.setErrorHandler((ErrorHandler)(this.errorHandler == null ? this : this.errorHandler));
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                parser.parse(is);
            }
            catch (SAXException e) {
                Exception ex = e.getException();
                if (ex != null && ex instanceof InterruptedIOException) {
                    throw (InterruptedIOException)ex;
                }
                throw new IOException(e.getMessage());
            }
            this.currentNode = null;
            Document ret = this.document;
            this.document = null;
            return ret;
        }
    }

    private class SvgUserAgent
    extends UserAgentAdapter {
        private DocumentHandler documentHandler;

        protected SvgUserAgent(DocumentHandler documentHandler) {
            this.documentHandler = documentHandler;
        }

        public String getXMLParserClassName() {
            return this.documentHandler.getXmlReaderClass();
        }
    }
}

