/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.print.tag.acroform.Option;
import org.ujac.print.tag.acroform.OptionHolder;
import org.ujac.print.tag.acroform.OptionTag;

public class ComboBoxAcroFieldTag
extends BaseAcroFieldTag
implements OptionHolder {
    public static final String TAG_NAME = "combo-box";
    protected String fieldValue = null;
    protected boolean editable = true;
    private List options = new ArrayList();

    public ComboBoxAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a combo box to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(FIELD_VALUE).addDefinition(FIELD_EDITABLE).addDefinition(FIELD_STATUS).addDefinition(CommonAttributes.FONT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(OptionTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.options.clear();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
        this.editable = this.getBooleanAttribute(FIELD_EDITABLE, true, true, null);
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        int numOptions = this.options.size();
        String[] choices = new String[numOptions];
        for (int i = 0; i < numOptions; ++i) {
            Option option = (Option)this.options.get(i);
            choices[i] = option.getText();
        }
        String[] choicesExports = new String[numOptions];
        for (int i = 0; i < numOptions; ++i) {
            Option option = (Option)this.options.get(i);
            choicesExports[i] = option.getValue();
        }
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            PdfWriter pdfWriter = this.getPdfWriter();
            TextField tf = new TextField(pdfWriter, this.getFieldDimensions(), this.fieldName);
            tf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            tf.setRotation(rotation);
            tf.setFontSize(font.getSize());
            tf.setText(this.fieldValue);
            tf.setBorderStyle(this.getBorderType());
            tf.setBorderWidth(this.getBorderWidth());
            tf.setBorderColor(this.getBorderColor());
            tf.setBackgroundColor(this.getBackgroundColor());
            tf.setTextColor(this.getTextColor());
            tf.setChoices(choices);
            tf.setChoices(choicesExports);
            tf.setOptions(0x1000000);
            PdfFormField ff = tf.getComboField();
            this.applyJavaScript(ff);
            return ff;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    public void addOption(Option option) throws TagAttributeException {
        this.options.add(option);
    }
}

