/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.RadioCheckField;
import java.awt.Color;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.print.tag.acroform.RadioButtonAcroFieldTag;

public class RadioGroupAcroFieldTag
extends BaseAcroFieldTag {
    public static final String TAG_NAME = "radio-group";
    protected PdfFormField radioGroup = null;
    protected String fieldValue = null;

    public RadioGroupAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a radio button group to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(FIELD_VALUE).addDefinition(CommonAttributes.FONT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(RadioButtonAcroFieldTag.class, 0, 999));
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public boolean isStructureChecksDisabled() {
        return true;
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
        this.borderWidth = this.getDimensionAttribute(CommonAttributes.BORDER_WIDTH, 1.0f, true, CommonStyleAttributes.BORDER_WIDTH);
        this.borderColor = this.getColorAttribute(CommonAttributes.BORDER_COLOR, Color.lightGray, true, CommonStyleAttributes.BORDER_COLOR);
        RadioCheckField bt = new RadioCheckField(this.getPdfWriter(), new Rectangle(0.0f, 0.0f, 0.0f, 0.0f), this.fieldName, this.fieldValue);
        bt.setOptions(0);
        DocumentFont font = this.getLocalFont();
        if (this.isAttributeDefined(CommonAttributes.FONT, CommonStyleAttributes.FONT_NAME)) {
            bt.setFont(font.getFont().getBaseFont());
            bt.setFontSize(font.getSize());
        }
        this.radioGroup = bt.getRadioGroup(false, false);
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        this.getPdfWriter().addAnnotation((PdfAnnotation)this.radioGroup);
        return null;
    }

    public boolean isVisibleElement() {
        return false;
    }

    public PdfFormField getRadioGroup() {
        return this.radioGroup;
    }

    public String getRadioGroupName() {
        return this.fieldName;
    }

    public String getRadioValue() {
        return this.fieldValue;
    }
}

