/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class DrawLineTag
extends BaseGraphicsTag {
    public static final String TAG_NAME = "draw-line";
    private static final AttributeDefinition LINE_X1 = X1.cloneAttrDef("The horizontal position of the start point of the line.");
    private static final AttributeDefinition LINE_Y1 = Y1.cloneAttrDef("The vertical position of the start point of the line.");
    private static final AttributeDefinition LINE_X2 = X2.cloneAttrDef("The horizontal position of the end point of the line.");
    private static final AttributeDefinition LINE_Y2 = Y2.cloneAttrDef("The vertical position of the end point of the line.");

    public DrawLineTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a line.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(LINE_X1).addDefinition(LINE_Y1).addDefinition(LINE_X2).addDefinition(LINE_Y2);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float x1 = this.getDimensionAttribute(X1, true, null);
        float y1 = this.getDimensionAttribute(Y1, true, null);
        float x2 = this.getDimensionAttribute(X2, true, null);
        float y2 = this.getDimensionAttribute(Y2, true, null);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.moveTo(x1, y1);
        cb.lineTo(x2, y2);
        cb.stroke();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

