/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class DrawRectangleTag
extends BaseGraphicsTag {
    private static final AttributeDefinition RECT_FILL = FILL.cloneAttrDef("Tells whether or not to fill the rectangle, default is false.");
    private static final AttributeDefinition RECT_X = X.cloneAttrDef("The horizontal position of the start point of the rectangle.");
    private static final AttributeDefinition RECT_Y = Y.cloneAttrDef("The vertical position of the start point of the rectangle.");
    protected static final AttributeDefinition RECT_WIDTH = new AttributeDefinition("width", 14, true, "The width of the rectangle.");
    protected static final AttributeDefinition RECT_HEIGHT = new AttributeDefinition("height", 14, true, "The height of the rectangle.");
    public static final String TAG_NAME = "draw-rectangle";

    public DrawRectangleTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a rectangle.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(RECT_FILL).addDefinition(RECT_X).addDefinition(RECT_Y).addDefinition(RECT_WIDTH).addDefinition(RECT_HEIGHT);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        boolean fill = this.getBooleanAttribute(FILL, false, true, null);
        float x = this.getDimensionAttribute(X, true, X);
        float y = this.getDimensionAttribute(Y, true, Y);
        float width = this.getDimensionAttribute(RECT_WIDTH, true, RECT_WIDTH);
        float height = this.getDimensionAttribute(RECT_HEIGHT, true, RECT_HEIGHT);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.rectangle(x, y, width, height);
        if (fill) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

